/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes.ltl;

import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

public class BuechiAutomatonNode {
    String name;
    Set<BuechiAutomatonNode> incoming;
    Set<BuechiAutomatonNode> successors = new HashSet<BuechiAutomatonNode>();
    Set<LTLNode> unprocessed;
    Set<LTLNode> processed;
    Set<LTLNode> next;
    private List<PredicateNode> labels = new ArrayList<PredicateNode>();
    boolean isInitialState = false;
    boolean isAcceptingState = false;

    public BuechiAutomatonNode(String name, Set<BuechiAutomatonNode> incoming, Set<LTLNode> unprocessed, Set<LTLNode> processed, Set<LTLNode> next) {
        this.name = name;
        this.incoming = incoming;
        this.unprocessed = unprocessed;
        this.processed = processed;
        this.next = next;
    }

    public void label() {
        for (BuechiAutomatonNode incomingNode : this.incoming) {
            if (!incomingNode.name.equals("init")) continue;
            this.isInitialState = true;
        }
        for (LTLNode processedNode : this.processed) {
            if (!(processedNode instanceof LTLBPredicateNode)) continue;
            this.labels.add(((LTLBPredicateNode)processedNode).getPredicate());
        }
    }

    public String toString() {
        StringJoiner nodeString = new StringJoiner("\n", "", "");
        nodeString.add(this.name + ": ");
        StringJoiner incomingString = new StringJoiner(", ", "{", "}");
        for (BuechiAutomatonNode buechiAutomatonNode : this.incoming) {
            incomingString.add(buechiAutomatonNode.name);
        }
        nodeString.add("Incoming: " + incomingString.toString());
        StringJoiner successorString = new StringJoiner(", ", "{", "}");
        for (BuechiAutomatonNode buechiAutomatonNode : this.successors) {
            successorString.add(buechiAutomatonNode.name);
        }
        nodeString.add("Successors: " + successorString.toString());
        StringJoiner stringJoiner = new StringJoiner("; ", "(", ")");
        for (LTLNode lTLNode : this.unprocessed) {
            stringJoiner.add(lTLNode.toString());
        }
        nodeString.add("Unprocessed: " + stringJoiner.toString());
        StringJoiner stringJoiner2 = new StringJoiner("; ", "(", ")");
        for (LTLNode lTLNode : this.processed) {
            stringJoiner2.add(lTLNode.toString());
        }
        nodeString.add("Processed: " + stringJoiner2.toString());
        StringJoiner stringJoiner3 = new StringJoiner("; ", "(", ")");
        for (LTLNode subNode : this.next) {
            stringJoiner3.add(subNode.toString());
        }
        nodeString.add("Next: " + stringJoiner3.toString());
        StringJoiner stringJoiner4 = new StringJoiner("; ", "(", ")");
        for (PredicateNode predicate : this.labels) {
            stringJoiner4.add(predicate.toString());
        }
        nodeString.add("Labels: " + stringJoiner4.toString());
        nodeString.add("Initial state? " + this.isInitialState);
        nodeString.add("Accepting state? " + this.isAcceptingState);
        return nodeString.toString();
    }

    public Set<BuechiAutomatonNode> getSuccessors() {
        return this.successors;
    }

    public List<PredicateNode> getLabels() {
        return this.labels;
    }

    public boolean isAccepting() {
        return this.isAcceptingState;
    }
}

