/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import java.util.HashSet;

public class SingleAssignSubstitutionNode
extends SubstitutionNode {
    private IdentifierExprNode identifier;
    private ExprNode value;

    public SingleAssignSubstitutionNode(IdentifierExprNode identifier, ExprNode expr) {
        this.identifier = identifier;
        this.value = expr;
        HashSet<DeclarationNode> set = new HashSet<DeclarationNode>();
        set.add(identifier.getDeclarationNode());
        super.setAssignedVariables(set);
    }

    public IdentifierExprNode getIdentifier() {
        return this.identifier;
    }

    public ExprNode getValue() {
        return this.value;
    }

    public String toString() {
        return this.identifier + " := " + this.value;
    }

    public void setValue(ExprNode value) {
        this.value = value;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        SingleAssignSubstitutionNode that = (SingleAssignSubstitutionNode)other;
        return this.identifier.equalAst(that.identifier) && this.value.equalAst(that.value);
    }
}

