/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class QuantifiedExpressionNode
extends SetComprehensionNode {
    private static final Map<Integer, QuantifiedExpressionOperator> map = new HashMap<Integer, QuantifiedExpressionOperator>();
    private QuantifiedExpressionOperator operator;
    private ExprNode expressionNode;

    public ExprNode getExpressionNode() {
        return this.expressionNode;
    }

    public void setExpr(ExprNode expr) {
        this.expressionNode = expr;
    }

    public QuantifiedExpressionNode(BMoThParser.ExpressionContext ctx, List<DeclarationNode> declarationList, PredicateNode predNode, ExprNode expressionNode, Token operator2) {
        super(ctx, declarationList, predNode);
        this.expressionNode = expressionNode;
        this.operator = this.loopUpOperator(operator2.getType());
    }

    private QuantifiedExpressionOperator loopUpOperator(int type) {
        if (map.containsKey(type)) {
            return map.get(type);
        }
        throw new AssertionError((Object)"Operator not implemented");
    }

    public QuantifiedExpressionOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        QuantifiedExpressionNode that = (QuantifiedExpressionNode)other;
        return this.operator.equals((Object)that.operator) && this.getExpressionNode().equalAst(that.getExpressionNode()) && this.expressionNode.equalAst(that.expressionNode) && NodeUtil.equalAst(this.getDeclarationList(), that.getDeclarationList());
    }

    static {
        map.put(144, QuantifiedExpressionOperator.QUANTIFIED_UNION);
        map.put(145, QuantifiedExpressionOperator.QUANTIFIED_INTER);
    }

    public static enum QuantifiedExpressionOperator {
        QUANTIFIED_UNION,
        QUANTIFIED_INTER;

    }
}

