/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;

public class ConditionSubstitutionNode
extends SubstitutionNode {
    private Kind kind;
    private PredicateNode condition;
    private SubstitutionNode substitution;

    public ConditionSubstitutionNode(Kind kind, PredicateNode condition, SubstitutionNode substitution) {
        this.condition = condition;
        this.substitution = substitution;
        this.kind = kind;
        super.setAssignedVariables(substitution.getAssignedVariables());
    }

    public SubstitutionNode getSubstitution() {
        return this.substitution;
    }

    public PredicateNode getCondition() {
        return this.condition;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        return "SELECT " + this.condition + " THEN " + this.substitution + " END";
    }

    public void setSubstitution(SubstitutionNode substitution) {
        this.substitution = substitution;
    }

    public void setCondition(PredicateNode predicate) {
        this.condition = predicate;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        ConditionSubstitutionNode that = (ConditionSubstitutionNode)other;
        return this.kind.equals((Object)that.kind) && this.condition.equalAst(that.condition) && this.substitution.equalAst(that.substitution);
    }

    public static enum Kind {
        PRECONDITION,
        ASSERT;

    }
}

