/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import java.util.List;
import java.util.stream.Collectors;

public class BecomesElementOfSubstitutionNode
extends SubstitutionNode {
    private List<IdentifierExprNode> identifiers;
    private ExprNode expression;

    public BecomesElementOfSubstitutionNode(List<IdentifierExprNode> identifiers, ExprNode expression) {
        this.identifiers = identifiers;
        this.expression = expression;
        super.setAssignedVariables(identifiers.stream().map(IdentifierExprNode::getDeclarationNode).collect(Collectors.toSet()));
    }

    public List<IdentifierExprNode> getIdentifiers() {
        return this.identifiers;
    }

    public ExprNode getExpression() {
        return this.expression;
    }

    public void setExpression(ExprNode expression) {
        this.expression = expression;
    }

    public String toString() {
        return this.identifiers.stream().map(Object::toString).collect(Collectors.joining(",")) + " :( " + this.expression + ")";
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        BecomesElementOfSubstitutionNode that = (BecomesElementOfSubstitutionNode)other;
        return this.expression.equalAst(that.expression) && NodeUtil.equalAst(this.identifiers, that.identifiers);
    }
}

