/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractIfAndSelectSubstitutionsNode
extends SubstitutionNode {
    protected List<PredicateNode> conditions;
    protected List<SubstitutionNode> substitutions;
    protected SubstitutionNode elseSubstitution;

    public AbstractIfAndSelectSubstitutionsNode(List<PredicateNode> conditions, List<SubstitutionNode> substitutions, SubstitutionNode elseSubstitution) {
        this.conditions = conditions;
        this.substitutions = substitutions;
        this.elseSubstitution = elseSubstitution;
        HashSet<DeclarationNode> assignedVariables = new HashSet<DeclarationNode>();
        substitutions.forEach(t -> assignedVariables.addAll(t.getAssignedVariables()));
        this.setAssignedVariables(assignedVariables);
    }

    public List<SubstitutionNode> getSubstitutions() {
        return this.substitutions;
    }

    public SubstitutionNode getElseSubstitution() {
        return this.elseSubstitution;
    }

    public List<PredicateNode> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<PredicateNode> conditions) {
        this.conditions = conditions;
    }

    public void setSubstitutions(List<SubstitutionNode> substitutions) {
        this.substitutions = substitutions;
    }

    public void setElseSubstitution(SubstitutionNode elseSub) {
        this.elseSubstitution = elseSub;
    }

    String prepareToString(String selectIf, String whenElsif) {
        StringBuilder sb = new StringBuilder();
        sb.append(selectIf).append(" ").append(this.conditions.get(0)).append(" THEN ").append(this.substitutions.get(0));
        for (int i = 1; i < this.conditions.size(); ++i) {
            sb.append(" ").append(whenElsif).append(" ").append(this.conditions.get(i)).append(" THEN ").append(this.substitutions.get(i));
        }
        if (null != this.elseSubstitution) {
            sb.append(" ELSE ").append(this.elseSubstitution);
        }
        sb.append(" END");
        return sb.toString();
    }
}

