/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast;

import de.bmoth.parser.ast.TypeErrorException;
import de.bmoth.parser.ast.nodes.AbstractIfAndSelectSubstitutionsNode;
import de.bmoth.parser.ast.nodes.AnySubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesElementOfSubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesSuchThatSubstitutionNode;
import de.bmoth.parser.ast.nodes.CastPredicateExpressionNode;
import de.bmoth.parser.ast.nodes.ConditionSubstitutionNode;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.DeferredSetNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetDeclarationNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetElementNode;
import de.bmoth.parser.ast.nodes.EnumerationSetNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IdentifierPredicateNode;
import de.bmoth.parser.ast.nodes.IfSubstitutionNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.OperationNode;
import de.bmoth.parser.ast.nodes.ParallelSubstitutionNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.nodes.QuantifiedExpressionNode;
import de.bmoth.parser.ast.nodes.QuantifiedPredicateNode;
import de.bmoth.parser.ast.nodes.SelectSubstitutionNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SkipSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import de.bmoth.parser.ast.nodes.TypedNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLFormula;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLKeywordNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.parser.ast.types.BType;
import de.bmoth.parser.ast.types.BoolType;
import de.bmoth.parser.ast.types.CoupleType;
import de.bmoth.parser.ast.types.DeferredSetElementType;
import de.bmoth.parser.ast.types.EnumeratedSetElementType;
import de.bmoth.parser.ast.types.IntegerOrSetOfPairs;
import de.bmoth.parser.ast.types.IntegerType;
import de.bmoth.parser.ast.types.SetOrIntegerType;
import de.bmoth.parser.ast.types.SetType;
import de.bmoth.parser.ast.types.UnificationException;
import de.bmoth.parser.ast.types.UntypedType;
import de.bmoth.parser.ast.visitors.AbstractVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TypeChecker
implements AbstractVisitor<BType, BType> {
    private static final String TYPE_ERROR = "TYPE_ERROR";
    private Set<ExpressionOperatorNode> minusNodes = new HashSet<ExpressionOperatorNode>();
    private Set<ExpressionOperatorNode> multOrCartNodes = new HashSet<ExpressionOperatorNode>();
    private Set<TypedNode> typedNodes = new HashSet<TypedNode>();

    public static void typecheckMachineNode(MachineNode machineNode) throws TypeErrorException {
        TypeChecker typeChecker = new TypeChecker();
        try {
            typeChecker.checkMachineNode(machineNode);
        }
        catch (TypeCheckerVisitorException e) {
            Logger logger = Logger.getLogger(e.getClass().getName());
            logger.log(Level.SEVERE, TYPE_ERROR, e);
            throw e.getTypeErrorException();
        }
    }

    public static void typecheckFormulaNode(FormulaNode formulaNode) throws TypeErrorException {
        TypeChecker typeChecker = new TypeChecker();
        try {
            typeChecker.checkFormulaNode(formulaNode);
        }
        catch (TypeCheckerVisitorException e) {
            Logger logger = Logger.getLogger(e.getClass().getName());
            logger.log(Level.SEVERE, TYPE_ERROR, e);
            throw e.getTypeErrorException();
        }
    }

    public static void typecheckLTLFormulaNode(LTLFormula ltlFormulaAst) throws TypeErrorException {
        TypeChecker typeChecker = new TypeChecker();
        try {
            typeChecker.checkLTLFormulaNode(ltlFormulaAst);
        }
        catch (TypeCheckerVisitorException e) {
            Logger logger = Logger.getLogger(e.getClass().getName());
            logger.log(Level.SEVERE, TYPE_ERROR, e);
            throw e.getTypeErrorException();
        }
    }

    private TypeChecker() {
    }

    private void checkFormulaNode(FormulaNode formulaNode) {
        for (DeclarationNode node : formulaNode.getImplicitDeclarations()) {
            this.setInitialType(node);
        }
        Node formula = formulaNode.getFormula();
        if (formula instanceof PredicateNode) {
            this.visitPredicateNode((PredicateNode)formula, BoolType.getInstance());
        } else {
            BType type = (BType)this.visitExprNode((ExprNode)formula, new UntypedType());
            if (type.isUntyped()) {
                throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer type of formula: " + type));
            }
        }
        for (DeclarationNode node : formulaNode.getImplicitDeclarations()) {
            if (!node.getType().isUntyped()) continue;
            throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the type of local variable '" + node.getName() + "' Current type: " + node.getType()));
        }
        this.performPostActions();
    }

    private void checkLTLFormulaNode(LTLFormula ltlFormulaAst) {
        for (DeclarationNode node : ltlFormulaAst.getImplicitDeclarations()) {
            node.setType(new UntypedType());
        }
        this.visitLTLNode(ltlFormulaAst.getLTLNode(), null);
        for (DeclarationNode node : ltlFormulaAst.getImplicitDeclarations()) {
            if (!node.getType().isUntyped()) continue;
            throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the type of local variable '" + node.getName() + "' Current type: " + node.getType()));
        }
        this.performPostActions();
    }

    private void setInitialType(DeclarationNode node) {
        if (node.getType() == null) {
            node.setType(new UntypedType());
        }
    }

    private void checkMachineNode(MachineNode machineNode) {
        for (EnumeratedSetDeclarationNode eSet : machineNode.getEnumaratedSets()) {
            DeclarationNode setDeclaration = eSet.getSetDeclaration();
            if (setDeclaration.getType() != null) continue;
            EnumeratedSetElementType userDefinedElementType = new EnumeratedSetElementType(setDeclaration.getName(), eSet.getElementsAsStrings());
            setDeclaration.setType(new SetType(userDefinedElementType));
            for (DeclarationNode element : eSet.getElements()) {
                element.setType(userDefinedElementType);
            }
        }
        machineNode.getDeferredSets().stream().filter(ds -> ds.getType() == null).forEach(ds -> ds.setType(new SetType(new DeferredSetElementType(ds.getName()))));
        machineNode.getConstants().forEach(this::setInitialType);
        if (machineNode.getProperties() != null) {
            this.visitPredicateNode(machineNode.getProperties(), BoolType.getInstance());
        }
        machineNode.getConstants().stream().filter(TypedNode::isUntyped).findFirst().ifPresent(con -> {
            throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the type of constant " + con.getName() + ". Type variable: " + con.getType()));
        });
        machineNode.getVariables().forEach(this::setInitialType);
        if (machineNode.getInvariant() != null) {
            this.visitPredicateNode(machineNode.getInvariant(), BoolType.getInstance());
        }
        machineNode.getVariables().stream().filter(TypedNode::isUntyped).findFirst().ifPresent(var -> {
            throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the type of variable " + var.getName() + ". Type variable: " + var.getType()));
        });
        if (machineNode.getInitialisation() != null) {
            this.visitSubstitutionNode(machineNode.getInitialisation(), null);
        }
        this.visitOperations(machineNode);
        this.performPostActions();
    }

    private void visitOperations(MachineNode machineNode) {
        for (OperationNode operationsNode : machineNode.getOperations()) {
            this.setDeclarationTypes(operationsNode.getOutputParams());
            this.setDeclarationTypes(operationsNode.getParams());
            this.visitSubstitutionNode(operationsNode.getSubstitution(), null);
        }
    }

    private void performPostActions() {
        BType type;
        for (TypedNode typedNode : this.typedNodes) {
            if (!typedNode.getType().isUntyped()) continue;
            if (typedNode instanceof DeclarationNode) {
                DeclarationNode var = (DeclarationNode)typedNode;
                throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the type of local variable " + var.getName() + ": " + typedNode.getType()));
            }
            if (!(typedNode instanceof ExpressionOperatorNode)) continue;
            ExpressionOperatorNode exprNode = (ExpressionOperatorNode)typedNode;
            throw new TypeCheckerVisitorException(new TypeErrorException("Can not infer the complete type of operator " + (Object)((Object)exprNode.getOperator()) + ": " + typedNode.getType()));
        }
        for (ExpressionOperatorNode expressionOperatorNode : this.minusNodes) {
            type = expressionOperatorNode.getType();
            if (!(type instanceof SetType)) continue;
            expressionOperatorNode.setOperator(ExpressionOperatorNode.ExpressionOperator.SET_SUBTRACTION);
        }
        for (ExpressionOperatorNode expressionOperatorNode : this.multOrCartNodes) {
            type = expressionOperatorNode.getType();
            if (!(type instanceof SetType)) continue;
            expressionOperatorNode.setOperator(ExpressionOperatorNode.ExpressionOperator.CARTESIAN_PRODUCT);
        }
    }

    @Override
    public BType visitPredicateOperatorNode(PredicateOperatorNode node, BType expected) {
        this.unify(expected, BoolType.getInstance(), node);
        List<PredicateNode> predicateArguments = node.getPredicateArguments();
        for (PredicateNode predicateNode : predicateArguments) {
            this.visitPredicateNode(predicateNode, BoolType.getInstance());
        }
        return BoolType.getInstance();
    }

    @Override
    public BType visitPredicateOperatorWithExprArgs(PredicateOperatorWithExprArgsNode node, BType expected) {
        this.unify(expected, BoolType.getInstance(), node);
        List<ExprNode> expressionNodes = node.getExpressionNodes();
        switch (node.getOperator()) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.visitExprNode(expressionNodes.get(1), this.visitExprNode(expressionNodes.get(0), new UntypedType()));
                break;
            }
            case NOT_BELONGING: 
            case ELEMENT_OF: {
                BType left = (BType)this.visitExprNode(expressionNodes.get(0), new UntypedType());
                this.visitExprNode(expressionNodes.get(1), new SetType(left));
                break;
            }
            case LESS_EQUAL: 
            case LESS: 
            case GREATER_EQUAL: 
            case GREATER: {
                this.visitExprNode(expressionNodes.get(0), IntegerType.getInstance());
                this.visitExprNode(expressionNodes.get(1), IntegerType.getInstance());
                break;
            }
            case INCLUSION: 
            case NON_INCLUSION: 
            case STRICT_INCLUSION: 
            case STRICT_NON_INCLUSION: {
                this.visitExprNode(expressionNodes.get(1), this.visitExprNode(expressionNodes.get(0), new SetType(new UntypedType())));
                break;
            }
            default: {
                throw new AssertionError((Object)"Not implemented");
            }
        }
        return BoolType.getInstance();
    }

    @Override
    public BType visitExprOperatorNode(ExpressionOperatorNode node, BType expected) {
        List<ExprNode> expressionNodes = node.getExpressionNodes();
        switch (node.getOperator()) {
            case PLUS: 
            case UNARY_MINUS: 
            case MOD: 
            case DIVIDE: 
            case POWER_OF: {
                expressionNodes.forEach(n -> {
                    BType cfr_ignored_0 = (BType)this.visitExprNode((ExprNode)n, IntegerType.getInstance());
                });
                return this.unify(expected, IntegerType.getInstance(), node);
            }
            case MULT: {
                BType found = new IntegerOrSetOfPairs(new UntypedType(), new UntypedType());
                found = this.unify(expected, found, node);
                ExprNode left = expressionNodes.get(0);
                ExprNode right = expressionNodes.get(1);
                if (found instanceof IntegerType) {
                    this.visitExprNode(left, IntegerType.getInstance());
                    this.visitExprNode(right, IntegerType.getInstance());
                } else if (found instanceof SetType) {
                    SetType setType = (SetType)found;
                    CoupleType coupleType = (CoupleType)setType.getSubType();
                    this.visitExprNode(left, new SetType(coupleType.getLeft()));
                    this.visitExprNode(right, new SetType(coupleType.getRight()));
                } else if (found instanceof IntegerOrSetOfPairs) {
                    BType integerOrSetOfPairs = found;
                    BType leftType = (BType)this.visitExprNode(left, ((IntegerOrSetOfPairs)integerOrSetOfPairs).getLeft());
                    if (leftType instanceof IntegerType) {
                        this.visitExprNode(right, IntegerType.getInstance());
                    } else if (leftType instanceof SetType) {
                        SetType s = (SetType)node.getType();
                        CoupleType c = (CoupleType)s.getSubType();
                        this.visitExprNode(right, new SetType(c.getRight()));
                    } else {
                        IntegerOrSetOfPairs s = (IntegerOrSetOfPairs)node.getType();
                        this.visitExprNode(right, s.getRight());
                    }
                } else {
                    throw new AssertionError();
                }
                this.multOrCartNodes.add(node);
                this.typedNodes.add(node);
                return node.getType();
            }
            case MINUS: {
                this.unify(expected, new SetOrIntegerType(new UntypedType()), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), node.getType());
                this.minusNodes.add(node);
                this.typedNodes.add(node);
                return node.getType();
            }
            case INTERVAL: {
                this.unify(expected, new SetType(IntegerType.getInstance()), node);
                this.visitExprNode(expressionNodes.get(0), IntegerType.getInstance());
                this.visitExprNode(expressionNodes.get(1), IntegerType.getInstance());
                return node.getType();
            }
            case SET_ENUMERATION: {
                SetType found = (SetType)this.unify(expected, new SetType(new UntypedType()), node);
                BType subtype = found.getSubType();
                for (ExprNode exprNode : expressionNodes) {
                    subtype = (BType)this.visitExprNode(exprNode, subtype);
                }
                return node.getType();
            }
            case MIN: 
            case MAX: {
                this.unify(expected, IntegerType.getInstance(), node);
                this.visitExprNode(expressionNodes.get(0), new SetType(IntegerType.getInstance()));
                return node.getType();
            }
            case MININT: 
            case MAXINT: {
                return this.unify(expected, IntegerType.getInstance(), node);
            }
            case INTEGER: 
            case NATURAL: 
            case NATURAL1: 
            case INT: 
            case NAT: 
            case NAT1: {
                return this.unify(expected, new SetType(IntegerType.getInstance()), node);
            }
            case FALSE: 
            case TRUE: {
                return this.unify(expected, BoolType.getInstance(), node);
            }
            case BOOL: {
                return this.unify(expected, new SetType(BoolType.getInstance()), node);
            }
            case SET_SUBTRACTION: 
            case INTERSECTION: 
            case UNION: {
                this.unify(expected, new SetType(new UntypedType()), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), node.getType());
                return node.getType();
            }
            case COUPLE: {
                return this.unify(expected, new CoupleType((BType)this.visitExprNode(expressionNodes.get(0), new UntypedType()), (BType)this.visitExprNode(expressionNodes.get(1), new UntypedType())), node);
            }
            case DOMAIN: {
                SetType argument = new SetType(new CoupleType(new UntypedType(), new UntypedType()));
                argument = (SetType)this.visitExprNode(expressionNodes.get(0), argument);
                CoupleType subType = (CoupleType)argument.getSubType();
                SetType found = new SetType(subType.getLeft());
                this.unify(expected, found, node);
                return node.getType();
            }
            case RANGE: {
                SetType setType = (SetType)this.unify(expected, new SetType(new UntypedType()), node);
                this.visitExprNode(expressionNodes.get(0), new SetType(new CoupleType(new UntypedType(), setType.getSubType())));
                return node.getType();
            }
            case CONCAT: {
                this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), node.getType());
                return node.getType();
            }
            case DIRECT_PRODUCT: {
                SetType found = new SetType(new CoupleType(new UntypedType(), new CoupleType(new UntypedType(), new UntypedType())));
                found = (SetType)this.unify(expected, found, node);
                CoupleType c1 = (CoupleType)found.getSubType();
                CoupleType c2 = (CoupleType)c1.getRight();
                BType typeOfT = c1.getLeft();
                BType typeOfU = c2.getLeft();
                BType typeOfV = c2.getRight();
                SetType leftArg = (SetType)this.visitExprNode(expressionNodes.get(0), new SetType(new CoupleType(typeOfT, typeOfU)));
                typeOfT = ((CoupleType)leftArg.getSubType()).getLeft();
                this.visitExprNode(expressionNodes.get(1), new SetType(new CoupleType(typeOfT, typeOfV)));
                return node.getType();
            }
            case DOMAIN_RESTRICTION: 
            case DOMAIN_SUBTRACTION: {
                this.unify(expected, this.createNewRelationType(), node);
                this.visitExprNode(expressionNodes.get(1), node.getType());
                this.visitExprNode(expressionNodes.get(0), new SetType(this.getLeftTypeOfRelationType(node.getType())));
                return node.getType();
            }
            case RANGE_RESTRICTION: 
            case RANGE_SUBTRATION: {
                this.unify(expected, this.createNewRelationType(), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), new SetType(this.getRightTypeOfRelationType(node.getType())));
                return node.getType();
            }
            case INSERT_FRONT: {
                this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
                this.visitExprNode(expressionNodes.get(1), node.getType());
                this.visitExprNode(expressionNodes.get(0), this.getRightTypeOfRelationType(node.getType()));
                return node.getType();
            }
            case INSERT_TAIL: {
                this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), this.getRightTypeOfRelationType(node.getType()));
                return node.getType();
            }
            case OVERWRITE_RELATION: {
                this.unify(expected, new SetType(new CoupleType(new UntypedType(), new UntypedType())), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), node.getType());
                return node.getType();
            }
            case INVERSE_RELATION: {
                SetType argType = (SetType)this.visitExprNode(expressionNodes.get(0), new SetType(new CoupleType(new UntypedType(), new UntypedType())));
                CoupleType c = (CoupleType)argType.getSubType();
                return this.unify(expected, new SetType(new CoupleType(c.getRight(), c.getLeft())), node);
            }
            case RESTRICT_FRONT: 
            case RESTRICT_TAIL: {
                this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
                this.visitExprNode(expressionNodes.get(0), node.getType());
                this.visitExprNode(expressionNodes.get(1), IntegerType.getInstance());
                return node.getType();
            }
            case GENERALIZED_INTER: 
            case GENERALIZED_UNION: {
                this.unify(expected, new SetType(new UntypedType()), node);
                this.visitExprNode(expressionNodes.get(0), new SetType(node.getType()));
                return ((SetType)node.getType()).getSubType();
            }
            case EMPTY_SEQUENCE: {
                this.typedNodes.add(node);
                return this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
            }
            case SEQ_ENUMERATION: {
                SetType found = (SetType)this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node);
                BType elementType = ((CoupleType)found.getSubType()).getRight();
                for (ExprNode exprNode : expressionNodes) {
                    elementType = (BType)this.visitExprNode(exprNode, elementType);
                }
                return node.getType();
            }
            case LAST: 
            case FIRST: {
                return this.unify(expected, this.getRightTypeOfRelationType((BType)this.visitExprNode(expressionNodes.get(0), new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())))), node);
            }
            case FRONT: 
            case TAIL: {
                return (BType)this.visitExprNode(expressionNodes.get(0), this.unify(expected, new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType())), node));
            }
            case SEQ: 
            case SEQ1: 
            case ISEQ: 
            case ISEQ1: {
                SetType found = (SetType)this.unify(expected, new SetType(new SetType(new CoupleType(IntegerType.getInstance(), new UntypedType()))), node);
                SetType type = (SetType)found.getSubType();
                CoupleType coupleType = (CoupleType)type.getSubType();
                this.visitExprNode(expressionNodes.get(0), new SetType(coupleType.getRight()));
                return node.getType();
            }
            case FUNCTION_CALL: {
                List<ExprNode> arguments = expressionNodes.stream().filter(e -> expressionNodes.get(0) != e).collect(Collectors.toList());
                arguments.forEach(e -> {
                    BType cfr_ignored_0 = (BType)this.visitExprNode((ExprNode)e, new UntypedType());
                });
                List<BType> typesList = arguments.stream().map(TypedNode::getType).collect(Collectors.toList());
                BType domType = this.createNestedCouple(typesList);
                SetType baseType = (SetType)this.visitExprNode(expressionNodes.get(0), new SetType(new CoupleType(domType, new UntypedType())));
                return this.unify(expected, ((CoupleType)baseType.getSubType()).getRight(), node);
            }
            case CARD: {
                this.visitExprNode(expressionNodes.get(0), new SetType(new UntypedType()));
                return this.unify(expected, IntegerType.getInstance(), node);
            }
            case EMPTY_SET: {
                this.typedNodes.add(node);
                return this.unify(expected, new SetType(new UntypedType()), node);
            }
            case SET_RELATION: {
                SetType found = new SetType(new SetType(new CoupleType(new UntypedType(), new UntypedType())));
                found = (SetType)this.unify(expected, found, node);
                SetType set = (SetType)found.getSubType();
                CoupleType couple = (CoupleType)set.getSubType();
                this.visitExprNode(node.getExpressionNodes().get(0), new SetType(couple.getLeft()));
                this.visitExprNode(node.getExpressionNodes().get(1), new SetType(couple.getRight()));
                return node.getType();
            }
        }
        throw new AssertionError();
    }

    private SetType createNewRelationType() {
        return new SetType(new CoupleType(new UntypedType(), new UntypedType()));
    }

    private BType getRightTypeOfRelationType(BType s) {
        SetType setType = (SetType)s;
        CoupleType c = (CoupleType)setType.getSubType();
        return c.getRight();
    }

    private BType getLeftTypeOfRelationType(BType s) {
        SetType setType = (SetType)s;
        CoupleType c = (CoupleType)setType.getSubType();
        return c.getLeft();
    }

    @Override
    public BType visitIdentifierExprNode(IdentifierExprNode node, BType expected) {
        return this.unify(expected, node.getDeclarationNode().getType(), node);
    }

    @Override
    public BType visitCastPredicateExpressionNode(CastPredicateExpressionNode node, BType expected) {
        this.visitPredicateNode(node.getPredicate(), BoolType.getInstance());
        return this.unify(expected, BoolType.getInstance(), node);
    }

    @Override
    public BType visitIdentifierPredicateNode(IdentifierPredicateNode node, BType expected) {
        return this.unify(expected, node.getDeclarationNode().getType(), node);
    }

    @Override
    public BType visitNumberNode(NumberNode node, BType expected) {
        return this.unify(expected, IntegerType.getInstance(), node);
    }

    private BType unify(BType expected, BType found, TypedNode node) {
        try {
            BType type = found.unify(expected);
            node.setType(type);
            return type;
        }
        catch (UnificationException e) {
            throw new TypeCheckerVisitorException(new TypeErrorException(expected, found, node, e));
        }
    }

    private void setDeclarationTypes(List<DeclarationNode> list) {
        for (DeclarationNode decl : list) {
            if (decl.getType() == null) {
                decl.setType(new UntypedType());
            }
            this.typedNodes.add(decl);
        }
    }

    @Override
    public BType visitQuantifiedExpressionNode(QuantifiedExpressionNode node, BType expected) {
        this.setDeclarationTypes(node.getDeclarationList());
        this.visitPredicateNode(node.getPredicateNode(), BoolType.getInstance());
        switch (node.getOperator()) {
            case QUANTIFIED_INTER: 
            case QUANTIFIED_UNION: {
                this.unify(expected, new SetType(new UntypedType()), node);
                this.visitPredicateNode(node.getPredicateNode(), BoolType.getInstance());
                this.visitExprNode(node.getExpressionNode(), node.getType());
                return node.getType();
            }
        }
        throw new AssertionError((Object)"Not implemented.");
    }

    @Override
    public BType visitSetComprehensionNode(SetComprehensionNode node, BType expected) {
        this.setDeclarationTypes(node.getDeclarationList());
        this.visitPredicateNode(node.getPredicateNode(), BoolType.getInstance());
        List<BType> types = node.getDeclarationList().stream().map(TypedNode::getType).collect(Collectors.toList());
        return this.unify(expected, new SetType(this.createNestedCouple(types)), node);
    }

    @Override
    public BType visitQuantifiedPredicateNode(QuantifiedPredicateNode node, BType expected) {
        this.unify(expected, BoolType.getInstance(), node);
        this.setDeclarationTypes(node.getDeclarationList());
        this.visitPredicateNode(node.getPredicateNode(), BoolType.getInstance());
        return BoolType.getInstance();
    }

    @Override
    public BType visitSelectSubstitutionNode(SelectSubstitutionNode node, BType expected) {
        this.visitConditionsAndSubstitionsNode(node);
        return null;
    }

    @Override
    public BType visitIfSubstitutionNode(IfSubstitutionNode node, BType expected) {
        this.visitConditionsAndSubstitionsNode(node);
        return null;
    }

    private void visitConditionsAndSubstitionsNode(AbstractIfAndSelectSubstitutionsNode node) {
        node.getConditions().forEach(t -> {
            BType cfr_ignored_0 = (BType)this.visitPredicateNode((PredicateNode)t, BoolType.getInstance());
        });
        node.getSubstitutions().forEach(t -> {
            BType cfr_ignored_0 = (BType)this.visitSubstitutionNode((SubstitutionNode)t, null);
        });
        if (node.getElseSubstitution() != null) {
            this.visitSubstitutionNode(node.getElseSubstitution(), null);
        }
    }

    @Override
    public BType visitConditionSubstitutionNode(ConditionSubstitutionNode node, BType expected) {
        this.visitPredicateNode(node.getCondition(), BoolType.getInstance());
        this.visitSubstitutionNode(node.getSubstitution(), expected);
        return null;
    }

    @Override
    public BType visitSingleAssignSubstitution(SingleAssignSubstitutionNode node, BType expected) {
        BType type = this.visitIdentifierExprNode(node.getIdentifier(), new UntypedType());
        this.visitExprNode(node.getValue(), type);
        return null;
    }

    @Override
    public BType visitParallelSubstitutionNode(ParallelSubstitutionNode node, BType expected) {
        for (SubstitutionNode sub : node.getSubstitutions()) {
            this.visitSubstitutionNode(sub, null);
        }
        return null;
    }

    @Override
    public BType visitAnySubstitution(AnySubstitutionNode node, BType expected) {
        this.setDeclarationTypes(node.getParameters());
        this.visitPredicateNode(node.getWherePredicate(), BoolType.getInstance());
        this.visitSubstitutionNode(node.getThenSubstitution(), null);
        return null;
    }

    @Override
    public BType visitBecomesElementOfSubstitutionNode(BecomesElementOfSubstitutionNode node, BType expected) {
        List<BType> types = node.getIdentifiers().stream().map(t -> this.visitIdentifierExprNode((IdentifierExprNode)t, new UntypedType())).collect(Collectors.toList());
        SetType type = new SetType(this.createNestedCouple(types));
        this.visitExprNode(node.getExpression(), type);
        return null;
    }

    private BType createNestedCouple(List<BType> types) {
        BType left = types.get(0);
        for (int i = 1; i < types.size(); ++i) {
            left = new CoupleType(left, types.get(i));
        }
        return left;
    }

    @Override
    public BType visitBecomesSuchThatSubstitutionNode(BecomesSuchThatSubstitutionNode node, BType expected) {
        node.getIdentifiers().forEach(t -> this.visitIdentifierExprNode((IdentifierExprNode)t, new UntypedType()));
        this.visitPredicateNode(node.getPredicate(), BoolType.getInstance());
        return null;
    }

    @Override
    public BType visitSkipSubstitutionNode(SkipSubstitutionNode node, BType expected) {
        return null;
    }

    @Override
    public BType visitEnumerationSetNode(EnumerationSetNode node, BType expected) {
        return this.unify(expected, node.getEnumeratedSetDeclarationNode().getSetDeclaration().getType(), node);
    }

    @Override
    public BType visitDeferredSetNode(DeferredSetNode node, BType expected) {
        return this.unify(expected, node.getDeclarationNode().getType(), node);
    }

    @Override
    public BType visitEnumeratedSetElementNode(EnumeratedSetElementNode node, BType expected) {
        return this.unify(expected, node.getDeclarationNode().getType(), node);
    }

    @Override
    public BType visitLTLPrefixOperatorNode(LTLPrefixOperatorNode node, BType expected) {
        this.visitLTLNode(node.getArgument(), expected);
        return null;
    }

    @Override
    public BType visitLTLKeywordNode(LTLKeywordNode node, BType expected) {
        return null;
    }

    @Override
    public BType visitLTLInfixOperatorNode(LTLInfixOperatorNode node, BType expected) {
        this.visitLTLNode(node.getLeft(), expected);
        this.visitLTLNode(node.getRight(), expected);
        return null;
    }

    @Override
    public BType visitLTLBPredicateNode(LTLBPredicateNode node, BType expected) {
        this.visitPredicateNode(node.getPredicate(), BoolType.getInstance());
        return null;
    }

    class TypeCheckerVisitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1744515995462230895L;
        private final TypeErrorException typeErrorException;

        TypeCheckerVisitorException(TypeErrorException typeErrorException) {
            this.typeErrorException = typeErrorException;
        }

        public TypeErrorException getTypeErrorException() {
            return this.typeErrorException;
        }
    }
}

