/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.antlr.BMoThParserBaseVisitor;
import de.bmoth.parser.ast.nodes.AnySubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesElementOfSubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesSuchThatSubstitutionNode;
import de.bmoth.parser.ast.nodes.CastPredicateExpressionNode;
import de.bmoth.parser.ast.nodes.ConditionSubstitutionNode;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.DeferredSetNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetDeclarationNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetElementNode;
import de.bmoth.parser.ast.nodes.EnumerationSetNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IdentifierPredicateNode;
import de.bmoth.parser.ast.nodes.IfSubstitutionNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.OperationNode;
import de.bmoth.parser.ast.nodes.ParallelSubstitutionNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.nodes.QuantifiedExpressionNode;
import de.bmoth.parser.ast.nodes.QuantifiedPredicateNode;
import de.bmoth.parser.ast.nodes.SelectSubstitutionNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SkipSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLFormula;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLKeywordNode;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.parser.cst.BDefinition;
import de.bmoth.parser.cst.FormulaAnalyser;
import de.bmoth.parser.cst.LTLFormulaAnalyser;
import de.bmoth.parser.cst.MachineAnalyser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SemanticAstCreator {
    private final Map<TerminalNode, TerminalNode> declarationReferences;
    private final HashMap<TerminalNode, DeclarationNode> declarationMap = new HashMap();
    private final Map<ParserRuleContext, BDefinition> definitionCallReplacements;
    private final Map<TerminalNode, BMoThParser.ExpressionContext> argumentReplacement = new HashMap<TerminalNode, BMoThParser.ExpressionContext>();
    private final Map<BMoThParser.EnumeratedSetContext, EnumeratedSetDeclarationNode> enumerations = new HashMap<BMoThParser.EnumeratedSetContext, EnumeratedSetDeclarationNode>();
    private final Node semanticNode;

    public Node getAstNode() {
        return this.semanticNode;
    }

    public SemanticAstCreator(MachineAnalyser machineAnalyser) {
        PredicateNode pred;
        this.declarationReferences = machineAnalyser.getDeclarationReferences();
        this.definitionCallReplacements = machineAnalyser.getDefinitionCallReplacements();
        MachineNode machineNode = new MachineNode(null, null);
        machineNode.setConstants(this.createDeclarationList(machineAnalyser.getConstants()));
        machineNode.setVariables(this.createDeclarationList(machineAnalyser.getVariables()));
        this.addEnumeratedSets(machineAnalyser.getEnumeratedSets(), machineNode);
        this.addDeferredSets(machineAnalyser.getDeferredSetContexts(), machineNode);
        FormulaVisitor formulaVisitor = new FormulaVisitor();
        if (null != machineAnalyser.getPropertiesClause()) {
            pred = (PredicateNode)machineAnalyser.getPropertiesClause().predicate().accept(formulaVisitor);
            machineNode.setProperties(pred);
        }
        if (null != machineAnalyser.getInvariantClause()) {
            pred = (PredicateNode)machineAnalyser.getInvariantClause().predicate().accept(formulaVisitor);
            machineNode.setInvariant(pred);
        }
        if (null != machineAnalyser.getInitialisationClause()) {
            SubstitutionNode substitution = (SubstitutionNode)machineAnalyser.getInitialisationClause().substitution().accept(formulaVisitor);
            machineNode.setInitialisation(substitution);
        }
        Map<String, BMoThParser.LtlStartContext> ltlFormulaMap = machineAnalyser.getLTLFormulaMap();
        for (Map.Entry<String, BMoThParser.LtlStartContext> entry : ltlFormulaMap.entrySet()) {
            String name = entry.getKey();
            BMoThParser.LtlStartContext value = entry.getValue();
            LTLNode ltlNode = (LTLNode)value.accept(formulaVisitor);
            LTLFormula ltlFormula = new LTLFormula();
            ltlFormula.setName(name);
            ltlFormula.setFormula(ltlNode);
            machineNode.addLTLFormula(ltlFormula);
        }
        this.createOperations(machineAnalyser, machineNode, formulaVisitor);
        this.semanticNode = machineNode;
    }

    private void createOperations(MachineAnalyser machineAnalyser, MachineNode machineNode, FormulaVisitor formulaVisitor) {
        ArrayList<OperationNode> operationNodes = new ArrayList<OperationNode>();
        for (BMoThParser.OperationContext operationContext : machineAnalyser.getOperations()) {
            ArrayList<DeclarationNode> outputParamNodes = new ArrayList();
            if (operationContext.outputParams != null) {
                outputParamNodes = this.createDeclarationNodeList(operationContext.outputParams.IDENTIFIER());
            }
            ArrayList<DeclarationNode> paramNodes = new ArrayList();
            if (operationContext.params != null) {
                paramNodes = this.createDeclarationNodeList(operationContext.params.IDENTIFIER());
            }
            SubstitutionNode sub = (SubstitutionNode)operationContext.substitution().accept(formulaVisitor);
            OperationNode operationNode = new OperationNode(operationContext.IDENTIFIER().getText(), outputParamNodes, sub, paramNodes);
            operationNodes.add(operationNode);
        }
        machineNode.setOperations(operationNodes);
    }

    public SemanticAstCreator(FormulaAnalyser formulaAnalyser) {
        this.declarationReferences = formulaAnalyser.getDeclarationReferences();
        this.definitionCallReplacements = new LinkedHashMap<ParserRuleContext, BDefinition>();
        BMoThParser.FormulaContext formulaContext = formulaAnalyser.getFormula();
        FormulaNode.FormulaType type = formulaContext.expression() != null ? FormulaNode.FormulaType.EXPRESSION_FORMULA : FormulaNode.FormulaType.PREDICATE_FORMULA;
        FormulaNode formulaNode = new FormulaNode(type);
        formulaNode.setImplicitDeclarations(this.createDeclarationList(formulaAnalyser.getImplicitDeclarations()));
        FormulaVisitor formulaVisitor = new FormulaVisitor();
        Node node = type == FormulaNode.FormulaType.EXPRESSION_FORMULA ? (Node)formulaContext.expression().accept(formulaVisitor) : (Node)formulaContext.predicate().accept(formulaVisitor);
        formulaNode.setFormula(node);
        this.semanticNode = formulaNode;
    }

    public SemanticAstCreator(LTLFormulaAnalyser formulaAnalyser) {
        this.declarationReferences = formulaAnalyser.getDeclarationReferences();
        this.definitionCallReplacements = new LinkedHashMap<ParserRuleContext, BDefinition>();
        FormulaVisitor formulaVisitor = new FormulaVisitor();
        LTLNode node = (LTLNode)formulaAnalyser.getLTLStartContext().ltlFormula().accept(formulaVisitor);
        LTLFormula ltlFormula = new LTLFormula();
        ltlFormula.setFormula(node);
        ltlFormula.setImplicitDeclarations(this.createDeclarationList(formulaAnalyser.getImplicitDeclarations()));
        this.semanticNode = ltlFormula;
    }

    private void addDeferredSets(List<BMoThParser.DeferredSetContext> deferredSetContexts, MachineNode machineNode) {
        for (BMoThParser.DeferredSetContext deferredSetContext : deferredSetContexts) {
            Token token = deferredSetContext.IDENTIFIER().getSymbol();
            DeclarationNode setDeclNode = new DeclarationNode(deferredSetContext.IDENTIFIER(), token.getText());
            this.declarationMap.put(deferredSetContext.IDENTIFIER(), setDeclNode);
            machineNode.addDeferredSet(setDeclNode);
        }
    }

    private List<DeclarationNode> createDeclarationList(List<TerminalNode> list) {
        ArrayList<DeclarationNode> declarationList = new ArrayList<DeclarationNode>();
        for (TerminalNode terminalNode : list) {
            DeclarationNode declNode = new DeclarationNode(terminalNode, terminalNode.getSymbol().getText());
            declarationList.add(declNode);
            this.declarationMap.put(terminalNode, declNode);
        }
        return declarationList;
    }

    private List<DeclarationNode> createDeclarationList(Map<String, TerminalNode> map) {
        ArrayList<DeclarationNode> declarationList = new ArrayList<DeclarationNode>();
        for (Map.Entry<String, TerminalNode> entry : map.entrySet()) {
            TerminalNode terminalNode = entry.getValue();
            DeclarationNode declNode = new DeclarationNode(terminalNode, terminalNode.getSymbol().getText());
            declarationList.add(declNode);
            this.declarationMap.put(terminalNode, declNode);
        }
        return declarationList;
    }

    private List<DeclarationNode> createDeclarationNodeList(List<TerminalNode> list) {
        ArrayList<DeclarationNode> declarationList = new ArrayList<DeclarationNode>();
        for (TerminalNode terminalNode : list) {
            Token token = terminalNode.getSymbol();
            DeclarationNode declNode = new DeclarationNode(terminalNode, token.getText());
            declarationList.add(declNode);
            this.declarationMap.put(terminalNode, declNode);
        }
        return declarationList;
    }

    private void addEnumeratedSets(List<BMoThParser.EnumeratedSetContext> enumerationsContexts, MachineNode machineNode) {
        for (BMoThParser.EnumeratedSetContext enumeratedSetContext : enumerationsContexts) {
            Token token = enumeratedSetContext.IDENTIFIER().getSymbol();
            DeclarationNode setDeclNode = new DeclarationNode(enumeratedSetContext.IDENTIFIER(), token.getText());
            this.declarationMap.put(enumeratedSetContext.IDENTIFIER(), setDeclNode);
            List<DeclarationNode> declarationList = this.createDeclarationNodeList(enumeratedSetContext.identifier_list().IDENTIFIER());
            EnumeratedSetDeclarationNode enumerationSet = new EnumeratedSetDeclarationNode(setDeclNode, declarationList);
            this.enumerations.put(enumeratedSetContext, enumerationSet);
            machineNode.addSetEnumeration(enumerationSet);
        }
    }

    class FormulaVisitor
    extends BMoThParserBaseVisitor<Node> {
        BDefinition.KIND currentKind;

        FormulaVisitor() {
        }

        public Node visitChildren(RuleNode node) {
            throw new AssertionError((Object)(node.getClass() + " is not implemented yet in semantic Ast creator."));
        }

        @Override
        public Node visitQuantifiedPredicate(BMoThParser.QuantifiedPredicateContext ctx) {
            List declarationList = SemanticAstCreator.this.createDeclarationNodeList(ctx.quantified_variables_list().identifier_list().IDENTIFIER());
            PredicateNode predNode = (PredicateNode)ctx.predicate().accept(this);
            return new QuantifiedPredicateNode(ctx, declarationList, predNode);
        }

        @Override
        public Node visitEmptySequenceExpression(BMoThParser.EmptySequenceExpressionContext ctx) {
            return new ExpressionOperatorNode(ctx, new ArrayList<ExprNode>(), ExpressionOperatorNode.ExpressionOperator.EMPTY_SEQUENCE);
        }

        @Override
        public Node visitSequenceEnumerationExpression(BMoThParser.SequenceEnumerationExpressionContext ctx) {
            if (ctx.expression_list() == null) {
                return new ExpressionOperatorNode(ctx, new ArrayList<ExprNode>(), ExpressionOperatorNode.ExpressionOperator.EMPTY_SEQUENCE);
            }
            return new ExpressionOperatorNode(ctx, this.createExprNodeList(ctx.expression_list().expression()), ExpressionOperatorNode.ExpressionOperator.SEQ_ENUMERATION);
        }

        @Override
        public Node visitFunctionCallExpression(BMoThParser.FunctionCallExpressionContext ctx) {
            if (SemanticAstCreator.this.definitionCallReplacements.containsKey((Object)ctx)) {
                this.currentKind = BDefinition.KIND.EXPRESSION;
                return this.replaceByDefinitionBody(ctx, (BDefinition)SemanticAstCreator.this.definitionCallReplacements.get((Object)ctx));
            }
            return new ExpressionOperatorNode(ctx, this.createExprNodeList(ctx.expression()), ExpressionOperatorNode.ExpressionOperator.FUNCTION_CALL);
        }

        @Override
        public ExprNode visitIdentifierExpression(BMoThParser.IdentifierExpressionContext ctx) {
            TerminalNode declNode = (TerminalNode)SemanticAstCreator.this.declarationReferences.get(ctx.IDENTIFIER());
            return this.handleExpressionIdentifier(ctx, ctx.IDENTIFIER(), declNode);
        }

        private ExprNode handleExpressionIdentifier(ParserRuleContext ctx, TerminalNode terminalNode, TerminalNode declNode) {
            if (SemanticAstCreator.this.definitionCallReplacements.containsKey(ctx)) {
                this.currentKind = BDefinition.KIND.EXPRESSION;
                return (ExprNode)((BDefinition)SemanticAstCreator.this.definitionCallReplacements.get(ctx)).getDefinitionContext().definition_body().accept(this);
            }
            if (SemanticAstCreator.this.argumentReplacement.containsKey(declNode)) {
                BMoThParser.ExpressionContext expressionContext = (BMoThParser.ExpressionContext)((Object)SemanticAstCreator.this.argumentReplacement.get(declNode));
                return (ExprNode)expressionContext.accept(this);
            }
            if (declNode.getParent() instanceof BMoThParser.EnumeratedSetContext) {
                EnumeratedSetDeclarationNode enumeratedSetDeclarationNode = (EnumeratedSetDeclarationNode)SemanticAstCreator.this.enumerations.get(declNode.getParent());
                return new EnumerationSetNode((ParseTree)terminalNode, enumeratedSetDeclarationNode, terminalNode.getText());
            }
            if (declNode.getParent() instanceof BMoThParser.DeferredSetContext) {
                DeclarationNode declarationNode = (DeclarationNode)SemanticAstCreator.this.declarationMap.get(declNode);
                return new DeferredSetNode((ParseTree)terminalNode, declarationNode, terminalNode.getText());
            }
            if (declNode.getParent().getParent() instanceof BMoThParser.EnumeratedSetContext) {
                EnumeratedSetDeclarationNode enumeratedSetDeclarationNode = (EnumeratedSetDeclarationNode)SemanticAstCreator.this.enumerations.get(declNode.getParent().getParent());
                DeclarationNode declarationNode = (DeclarationNode)SemanticAstCreator.this.declarationMap.get(declNode);
                return new EnumeratedSetElementNode((ParseTree)terminalNode, enumeratedSetDeclarationNode, terminalNode.getText(), declarationNode);
            }
            return this.createIdentifierExprNode(terminalNode);
        }

        @Override
        public Node visitDefinitionAmbiguousCall(BMoThParser.DefinitionAmbiguousCallContext ctx) {
            TerminalNode declToken = (TerminalNode)SemanticAstCreator.this.declarationReferences.get(ctx.IDENTIFIER());
            if (this.currentKind == BDefinition.KIND.EXPRESSION) {
                if (null != ctx.expression_list()) {
                    List<BMoThParser.ExpressionContext> exprs = ctx.expression_list().exprs;
                    if (SemanticAstCreator.this.definitionCallReplacements.containsKey((Object)ctx)) {
                        this.currentKind = BDefinition.KIND.EXPRESSION;
                        BDefinition bDefinition = (BDefinition)SemanticAstCreator.this.definitionCallReplacements.get((Object)ctx);
                        for (BMoThParser.ExpressionContext value : exprs) {
                            TerminalNode terminalNode = bDefinition.getDefinitionContext().IDENTIFIER();
                            SemanticAstCreator.this.argumentReplacement.put(terminalNode, value);
                        }
                        return (Node)bDefinition.getDefinitionContext().definition_body().accept(this);
                    }
                    ArrayList<ExprNode> exprNodes = new ArrayList<ExprNode>();
                    exprNodes.add(this.createIdentifierExprNode(ctx.IDENTIFIER()));
                    return new ExpressionOperatorNode(ctx, exprNodes, ExpressionOperatorNode.ExpressionOperator.FUNCTION_CALL);
                }
                return this.handleExpressionIdentifier(ctx, ctx.IDENTIFIER(), declToken);
            }
            if (this.currentKind == BDefinition.KIND.PREDICATE) {
                return this.handlePredicateIdentifier(ctx, ctx.IDENTIFIER());
            }
            return this.visitChildren((RuleNode)ctx);
        }

        @Override
        public ExprNode visitDefinitionExpression(BMoThParser.DefinitionExpressionContext ctx) {
            return (ExprNode)ctx.expression().accept(this);
        }

        @Override
        public PredicateNode visitDefinitionPredicate(BMoThParser.DefinitionPredicateContext ctx) {
            return (PredicateNode)ctx.predicate().accept(this);
        }

        @Override
        public SubstitutionNode visitDefinitionSubstitution(BMoThParser.DefinitionSubstitutionContext ctx) {
            return (SubstitutionNode)ctx.substitution().accept(this);
        }

        @Override
        public PredicateNode visitPredicateIdentifier(BMoThParser.PredicateIdentifierContext ctx) {
            this.currentKind = BDefinition.KIND.PREDICATE;
            return this.handlePredicateIdentifier(ctx, ctx.IDENTIFIER());
        }

        private PredicateNode handlePredicateIdentifier(ParserRuleContext ctx, TerminalNode terminalNode) {
            if (SemanticAstCreator.this.definitionCallReplacements.containsKey(ctx)) {
                BDefinition bDefinition = (BDefinition)SemanticAstCreator.this.definitionCallReplacements.get(ctx);
                return (PredicateNode)bDefinition.getDefinitionContext().definition_body().accept(this);
            }
            return this.createIdentifierPredicateNode(terminalNode);
        }

        private Node replaceByDefinitionBody(BMoThParser.FunctionCallExpressionContext ctx, BDefinition bDefinition) {
            for (int i = 1; i < ctx.exprs.size(); ++i) {
                BMoThParser.ExpressionContext value = ctx.exprs.get(i);
                TerminalNode terminalNode = bDefinition.getDefinitionContext().identifier_list().IDENTIFIER().get(i - 1);
                SemanticAstCreator.this.argumentReplacement.put(terminalNode, value);
            }
            return (Node)bDefinition.getDefinitionContext().definition_body().accept(this);
        }

        @Override
        public PredicateNode visitPredicateDefinitionCall(BMoThParser.PredicateDefinitionCallContext ctx) {
            BDefinition bDefinition = (BDefinition)SemanticAstCreator.this.definitionCallReplacements.get((Object)ctx);
            for (int i = 0; i < ctx.expression().size(); ++i) {
                BMoThParser.ExpressionContext value = ctx.exprs.get(i);
                TerminalNode terminalNode = bDefinition.getDefinitionContext().identifier_list().IDENTIFIER(i);
                SemanticAstCreator.this.argumentReplacement.put(terminalNode, value);
            }
            BMoThParser.DefinitionPredicateContext defContext = (BMoThParser.DefinitionPredicateContext)bDefinition.getDefinitionContext().definition_body();
            return (PredicateNode)defContext.predicate().accept(this);
        }

        @Override
        public Node visitParenthesesPredicate(BMoThParser.ParenthesesPredicateContext ctx) {
            return (Node)ctx.predicate().accept(this);
        }

        @Override
        public Node visitParenthesesExpression(BMoThParser.ParenthesesExpressionContext ctx) {
            return (Node)ctx.expression().accept(this);
        }

        @Override
        public Node visitCastPredicateExpression(BMoThParser.CastPredicateExpressionContext ctx) {
            PredicateNode predicate = (PredicateNode)ctx.predicate().accept(this);
            return new CastPredicateExpressionNode(ctx, predicate);
        }

        @Override
        public Node visitQuantifiedExpression(BMoThParser.QuantifiedExpressionContext ctx) {
            List declarationList = SemanticAstCreator.this.createDeclarationNodeList(ctx.quantified_variables_list().identifier_list().IDENTIFIER());
            PredicateNode predNode = (PredicateNode)ctx.predicate().accept(this);
            ExprNode exprNode = (ExprNode)ctx.expression().accept(this);
            return new QuantifiedExpressionNode(ctx, declarationList, predNode, exprNode, ctx.operator);
        }

        @Override
        public Node visitSetComprehensionExpression(BMoThParser.SetComprehensionExpressionContext ctx) {
            List declarationList = SemanticAstCreator.this.createDeclarationNodeList(ctx.identifier_list().IDENTIFIER());
            PredicateNode predNode = (PredicateNode)ctx.predicate().accept(this);
            return new SetComprehensionNode(ctx, declarationList, predNode);
        }

        @Override
        public Node visitNestedCoupleAsTupleExpression(BMoThParser.NestedCoupleAsTupleExpressionContext ctx) {
            List<BMoThParser.ExpressionContext> exprs = ctx.exprs;
            ExprNode left = (ExprNode)exprs.get(0).accept(this);
            for (int i = 1; i < exprs.size(); ++i) {
                ArrayList<ExprNode> list = new ArrayList<ExprNode>();
                list.add(left);
                list.add((ExprNode)exprs.get(i).accept(this));
                left = new ExpressionOperatorNode(ctx, list, ExpressionOperatorNode.ExpressionOperator.COUPLE);
            }
            return left;
        }

        @Override
        public ExpressionOperatorNode visitExpressionOperator(BMoThParser.ExpressionOperatorContext ctx) {
            String operator = ctx.operator.getText();
            return new ExpressionOperatorNode(ctx, this.createExprNodeList(ctx.expression()), operator);
        }

        @Override
        public ExprNode visitSetEnumerationExpression(BMoThParser.SetEnumerationExpressionContext ctx) {
            return new ExpressionOperatorNode(ctx, this.createExprNodeList(ctx.expression_list().expression()), ExpressionOperatorNode.ExpressionOperator.SET_ENUMERATION);
        }

        @Override
        public ExprNode visitEmptySetExpression(BMoThParser.EmptySetExpressionContext ctx) {
            return new ExpressionOperatorNode(ctx, new ArrayList<ExprNode>(), ExpressionOperatorNode.ExpressionOperator.EMPTY_SET);
        }

        @Override
        public ExprNode visitNumberExpression(BMoThParser.NumberExpressionContext ctx) {
            BigInteger value = new BigInteger(ctx.Number().getText());
            return new NumberNode((ParseTree)ctx, value);
        }

        @Override
        public PredicateNode visitPredicateOperator(BMoThParser.PredicateOperatorContext ctx) {
            ArrayList<PredicateNode> list = new ArrayList<PredicateNode>();
            List<BMoThParser.PredicateContext> predicate = ctx.predicate();
            for (BMoThParser.PredicateContext predicateContext : predicate) {
                PredicateNode predNode = (PredicateNode)predicateContext.accept(this);
                list.add(predNode);
            }
            return new PredicateOperatorNode(ctx, list);
        }

        @Override
        public PredicateNode visitPredicateOperatorWithExprArgs(BMoThParser.PredicateOperatorWithExprArgsContext ctx) {
            return new PredicateOperatorWithExprArgsNode(ctx, this.createExprNodeList(ctx.expression()));
        }

        private List<ExprNode> createExprNodeList(List<BMoThParser.ExpressionContext> list) {
            ArrayList<ExprNode> exprNodes = new ArrayList<ExprNode>();
            for (BMoThParser.ExpressionContext expressionContext : list) {
                ExprNode exprNode = (ExprNode)expressionContext.accept(this);
                exprNodes.add(exprNode);
            }
            return exprNodes;
        }

        @Override
        public Node visitBlockSubstitution(BMoThParser.BlockSubstitutionContext ctx) {
            return (Node)ctx.substitution().accept(this);
        }

        @Override
        public SubstitutionNode visitAssignSubstitution(BMoThParser.AssignSubstitutionContext ctx) {
            List idents = ctx.identifier_list().IDENTIFIER().stream().map(this::createIdentifierExprNode).collect(Collectors.toList());
            List expressions = ctx.expression_list().exprs.stream().map(t -> (ExprNode)t.accept(this)).collect(Collectors.toList());
            List<SubstitutionNode> sublist = IntStream.range(0, idents.size()).mapToObj(t -> new SingleAssignSubstitutionNode((IdentifierExprNode)idents.get(t), (ExprNode)expressions.get(t))).collect(Collectors.toList());
            if (sublist.size() == 1) {
                return (SubstitutionNode)sublist.get(0);
            }
            return new ParallelSubstitutionNode(sublist);
        }

        @Override
        public SubstitutionNode visitBecomesElementOfSubstitution(BMoThParser.BecomesElementOfSubstitutionContext ctx) {
            List<IdentifierExprNode> idents = ctx.identifier_list().IDENTIFIER().stream().map(this::createIdentifierExprNode).collect(Collectors.toList());
            ExprNode expression = (ExprNode)ctx.expression().accept(this);
            return new BecomesElementOfSubstitutionNode(idents, expression);
        }

        @Override
        public SubstitutionNode visitBecomesSuchThatSubstitution(BMoThParser.BecomesSuchThatSubstitutionContext ctx) {
            List<IdentifierExprNode> idents = ctx.identifier_list().IDENTIFIER().stream().map(this::createIdentifierExprNode).collect(Collectors.toList());
            PredicateNode predicate = (PredicateNode)ctx.predicate().accept(this);
            return new BecomesSuchThatSubstitutionNode(idents, predicate);
        }

        @Override
        public SubstitutionNode visitAnySubstitution(BMoThParser.AnySubstitutionContext ctx) {
            List declarationList = SemanticAstCreator.this.createDeclarationNodeList(ctx.identifier_list().IDENTIFIER());
            PredicateNode predNode = (PredicateNode)ctx.predicate().accept(this);
            SubstitutionNode sub = (SubstitutionNode)ctx.substitution().accept(this);
            return new AnySubstitutionNode(declarationList, predNode, sub);
        }

        @Override
        public SelectSubstitutionNode visitSelectSubstitution(BMoThParser.SelectSubstitutionContext ctx) {
            List<PredicateNode> predNodes = ctx.preds.stream().map(t -> (PredicateNode)t.accept(this)).collect(Collectors.toList());
            List<SubstitutionNode> subNodes = ctx.subs.stream().map(t -> (SubstitutionNode)t.accept(this)).collect(Collectors.toList());
            SubstitutionNode elseSubNode = null;
            elseSubNode = ctx.elseSub != null ? (SubstitutionNode)ctx.elseSub.accept(this) : new SkipSubstitutionNode();
            return new SelectSubstitutionNode(predNodes, subNodes, elseSubNode);
        }

        @Override
        public SubstitutionNode visitIfSubstitution(BMoThParser.IfSubstitutionContext ctx) {
            List<PredicateNode> predNodes = ctx.preds.stream().map(t -> (PredicateNode)t.accept(this)).collect(Collectors.toList());
            List<SubstitutionNode> subNodes = ctx.subs.stream().map(t -> (SubstitutionNode)t.accept(this)).collect(Collectors.toList());
            SubstitutionNode elseSubNode = null;
            elseSubNode = ctx.elseSub != null ? (SubstitutionNode)ctx.elseSub.accept(this) : new SkipSubstitutionNode();
            return new IfSubstitutionNode(predNodes, subNodes, elseSubNode);
        }

        @Override
        public ConditionSubstitutionNode visitConditionSubstitution(BMoThParser.ConditionSubstitutionContext ctx) {
            PredicateNode predicate = (PredicateNode)ctx.predicate().accept(this);
            SubstitutionNode sub = (SubstitutionNode)ctx.substitution().accept(this);
            if (ctx.keyword.getType() == 18) {
                return new ConditionSubstitutionNode(ConditionSubstitutionNode.Kind.PRECONDITION, predicate, sub);
            }
            return new ConditionSubstitutionNode(ConditionSubstitutionNode.Kind.ASSERT, predicate, sub);
        }

        private IdentifierExprNode createIdentifierExprNode(TerminalNode terminalNode) {
            Token token = terminalNode.getSymbol();
            TerminalNode declNode = (TerminalNode)SemanticAstCreator.this.declarationReferences.get(terminalNode);
            DeclarationNode declarationNode = (DeclarationNode)SemanticAstCreator.this.declarationMap.get(declNode);
            if (declarationNode == null) {
                throw new AssertionError((Object)("Can not find declaration node of identifier '" + token.getText() + "' Line " + token.getLine() + " Pos " + token.getCharPositionInLine()));
            }
            return new IdentifierExprNode(terminalNode, declarationNode);
        }

        private IdentifierPredicateNode createIdentifierPredicateNode(TerminalNode terminalNode) {
            Token token = terminalNode.getSymbol();
            TerminalNode declNode = (TerminalNode)SemanticAstCreator.this.declarationReferences.get(terminalNode);
            DeclarationNode declarationNode = (DeclarationNode)SemanticAstCreator.this.declarationMap.get(declNode);
            if (declarationNode == null) {
                throw new AssertionError((Object)(token.getText() + " Line " + token.getLine()));
            }
            return new IdentifierPredicateNode(terminalNode, declarationNode);
        }

        @Override
        public SubstitutionNode visitSkipSubstitution(BMoThParser.SkipSubstitutionContext ctx) {
            return new SkipSubstitutionNode();
        }

        @Override
        public SubstitutionNode visitParallelSubstitution(BMoThParser.ParallelSubstitutionContext ctx) {
            ArrayList<SubstitutionNode> result = new ArrayList<SubstitutionNode>();
            List<BMoThParser.SubstitutionContext> substitution = ctx.substitution();
            for (BMoThParser.SubstitutionContext substitutionContext : substitution) {
                SubstitutionNode sub = (SubstitutionNode)substitutionContext.accept(this);
                result.add(sub);
            }
            return new ParallelSubstitutionNode(result);
        }

        @Override
        public LTLNode visitLtlStart(BMoThParser.LtlStartContext ctx) {
            return (LTLNode)ctx.ltlFormula().accept(this);
        }

        @Override
        public Node visitLTLPrefixOperator(BMoThParser.LTLPrefixOperatorContext ctx) {
            LTLNode argument = (LTLNode)ctx.ltlFormula().accept(this);
            LTLPrefixOperatorNode.Kind kind = null;
            switch (ctx.operator.getType()) {
                case 161: {
                    kind = LTLPrefixOperatorNode.Kind.GLOBALLY;
                    break;
                }
                case 162: {
                    kind = LTLPrefixOperatorNode.Kind.FINALLY;
                    break;
                }
                case 166: {
                    kind = LTLPrefixOperatorNode.Kind.NEXT;
                    break;
                }
                case 158: {
                    kind = LTLPrefixOperatorNode.Kind.NOT;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return new LTLPrefixOperatorNode(kind, argument);
        }

        @Override
        public Node visitLTLKeyword(BMoThParser.LTLKeywordContext ctx) {
            LTLKeywordNode.Kind kind = null;
            switch (ctx.keyword.getType()) {
                case 153: {
                    kind = LTLKeywordNode.Kind.TRUE;
                    break;
                }
                case 154: {
                    kind = LTLKeywordNode.Kind.FALSE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return new LTLKeywordNode(kind);
        }

        @Override
        public Node visitLTLBPredicate(BMoThParser.LTLBPredicateContext ctx) {
            PredicateNode node = (PredicateNode)ctx.predicate().accept(this);
            return new LTLBPredicateNode(node);
        }

        @Override
        public Node visitLTLParentheses(BMoThParser.LTLParenthesesContext ctx) {
            return (Node)ctx.ltlFormula().accept(this);
        }

        @Override
        public Node visitLTLInfixOperator(BMoThParser.LTLInfixOperatorContext ctx) {
            LTLNode left = (LTLNode)ctx.ltlFormula(0).accept(this);
            LTLNode right = (LTLNode)ctx.ltlFormula(1).accept(this);
            LTLInfixOperatorNode.Kind kind = null;
            switch (ctx.operator.getType()) {
                case 155: {
                    kind = LTLInfixOperatorNode.Kind.IMPLICATION;
                    break;
                }
                case 163: {
                    kind = LTLInfixOperatorNode.Kind.UNTIL;
                    break;
                }
                case 164: {
                    kind = LTLInfixOperatorNode.Kind.WEAK_UNTIL;
                    break;
                }
                case 165: {
                    kind = LTLInfixOperatorNode.Kind.RELEASE;
                    break;
                }
                case 156: {
                    kind = LTLInfixOperatorNode.Kind.AND;
                    break;
                }
                case 157: {
                    kind = LTLInfixOperatorNode.Kind.OR;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return new LTLInfixOperatorNode(kind, left, right);
        }
    }
}

