/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker.kind;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import de.bmoth.backend.z3.Z3SolverFactory;
import de.bmoth.modelchecker.ModelCheckingResult;
import de.bmoth.modelchecker.State;
import de.bmoth.modelchecker.SymbolicModelChecker;
import de.bmoth.parser.ast.nodes.MachineNode;

public class KInductionModelChecker
extends SymbolicModelChecker {
    private final Solver stepSolver = Z3SolverFactory.getZ3Solver(this.getContext());

    public KInductionModelChecker(MachineNode machine, int maxSteps) {
        super(machine, maxSteps);
    }

    @Override
    protected ModelCheckingResult doModelCheck() {
        for (int k = 0; k < this.maxSteps; ++k) {
            int i;
            this.baseSolver.reset();
            this.baseSolver.add(new BoolExpr[]{this.init()});
            for (int i2 = 1; i2 <= k; ++i2) {
                this.baseSolver.add(new BoolExpr[]{this.transition(i2 - 1, i2)});
            }
            this.baseSolver.add(new BoolExpr[]{this.negatedInvariant(k)});
            Status check = this.baseSolver.check();
            if (check == Status.SATISFIABLE) {
                State counterExample = this.getStateFromModel(this.baseSolver.getModel(), k);
                return ModelCheckingResult.createCounterExampleFound(k, counterExample, this.baseSolver.getModel());
            }
            this.stepSolver.reset();
            this.stepSolver.add(new BoolExpr[0]);
            this.stepSolver.add(new BoolExpr[]{this.distinctVectors(k)});
            for (i = 0; i <= k; ++i) {
                this.stepSolver.add(new BoolExpr[]{this.transition(i - 1, i)});
            }
            for (i = 0; i <= k; ++i) {
                this.stepSolver.add(new BoolExpr[]{this.invariant(i)});
            }
            this.stepSolver.add(new BoolExpr[]{this.negatedInvariant(k + 1)});
            Status checkStep = this.stepSolver.check();
            if (checkStep != Status.UNSATISFIABLE) continue;
            return ModelCheckingResult.createVerified(k, null);
        }
        return ModelCheckingResult.createExceededMaxSteps(this.maxSteps);
    }
}

