/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker;

import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Model;
import de.bmoth.modelchecker.State;
import de.bmoth.modelchecker.StateSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;

public class ModelCheckingResult {
    private final int steps;
    private final State lastState;
    private final Type type;
    private final String reason;
    private final StateSpace stateSpace;
    private final List<State> counterExamplePath;

    private ModelCheckingResult(State lastState, int steps, Type type, String reason, StateSpace stateSpace, List<State> counterExamplePath) {
        this.lastState = lastState;
        this.steps = steps;
        this.type = type;
        this.reason = reason;
        this.stateSpace = stateSpace;
        this.counterExamplePath = counterExamplePath;
    }

    public static ModelCheckingResult createVerified(int steps, StateSpace stateSpace) {
        return new ModelCheckingResult(null, steps, Type.VERIFIED, null, stateSpace, null);
    }

    public static ModelCheckingResult createAborted(int steps) {
        return new ModelCheckingResult(null, steps, Type.ABORTED, null, null, null);
    }

    public static ModelCheckingResult createUnknown(int steps, String reason) {
        return new ModelCheckingResult(null, steps, Type.UNKNOWN, reason, null, null);
    }

    public static ModelCheckingResult createCounterExampleFound(int steps, State lastState, StateSpace stateSpace) {
        return new ModelCheckingResult(lastState, steps, Type.COUNTER_EXAMPLE_FOUND, null, stateSpace, ModelCheckingResult.findCounterExamplePath(stateSpace, lastState));
    }

    public static ModelCheckingResult createCounterExampleFound(int steps, State lastState, Model model) {
        return new ModelCheckingResult(lastState, steps, Type.COUNTER_EXAMPLE_FOUND, null, null, ModelCheckingResult.findCounterExamplePath(model));
    }

    public static ModelCheckingResult createLTLCounterExampleFound(int steps, State lastState) {
        return new ModelCheckingResult(lastState, steps, Type.LTL_COUNTER_EXAMPLE_FOUND, null, null, null);
    }

    public static ModelCheckingResult createExceededMaxSteps(int maxSteps) {
        return new ModelCheckingResult(null, maxSteps, Type.EXCEEDED_MAX_STEPS, null, null, null);
    }

    public State getLastState() {
        return this.lastState;
    }

    private static List<State> findCounterExamplePath(StateSpace stateSpace, State lastState) {
        if (stateSpace != null && lastState != null) {
            DijkstraShortestPath pathFinder = new DijkstraShortestPath((Graph)stateSpace);
            Optional<List> shortestPath = stateSpace.rootVertexSet().stream().filter(arg_0 -> ModelCheckingResult.lambda$findCounterExamplePath$0((ShortestPathAlgorithm)pathFinder, lastState, arg_0)).map(arg_0 -> ModelCheckingResult.lambda$findCounterExamplePath$1((ShortestPathAlgorithm)pathFinder, lastState, arg_0)).min((first, second) -> first.size() < second.size() ? 1 : -1);
            return shortestPath.orElseGet(Collections::emptyList);
        }
        return Collections.emptyList();
    }

    private static List<State> findCounterExamplePath(Model model) {
        ArrayList<State> path = new ArrayList<State>();
        HashMap<Integer, HashMap> states = new HashMap<Integer, HashMap>();
        for (FuncDecl decl : model.getDecls()) {
            String name = decl.getName().toString();
            Expr value = model.getConstInterp(decl);
            if (!name.contains("'")) continue;
            int index = Integer.parseInt(name.split("'")[1]);
            HashMap indexedStates = states.containsKey(index) ? (HashMap)states.get(index) : new HashMap();
            indexedStates.put(name.split("'")[0], value);
            states.put(index, indexedStates);
        }
        for (Map.Entry entry : states.entrySet()) {
            path.add(new State((Map)entry.getValue()));
        }
        return path;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isCorrect() {
        return this.type == Type.VERIFIED;
    }

    public StateSpace getStateSpace() {
        return this.stateSpace;
    }

    public int getSteps() {
        return this.steps;
    }

    public String getReason() {
        return this.reason;
    }

    public List<State> getCounterExamplePath() {
        return this.counterExamplePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.name()).append(' ');
        switch (this.type) {
            case COUNTER_EXAMPLE_FOUND: {
                sb.append(this.lastState.toString()).append(' ');
                break;
            }
            case UNKNOWN: {
                sb.append(this.reason).append(' ');
                break;
            }
            case LTL_COUNTER_EXAMPLE_FOUND: {
                sb.append(this.lastState.toString()).append(' ');
                break;
            }
        }
        return sb.append("after ").append(this.steps).append(" steps").toString();
    }

    private static /* synthetic */ List lambda$findCounterExamplePath$1(ShortestPathAlgorithm pathFinder, State lastState, State root) {
        return pathFinder.getPath((Object)root, (Object)lastState).getVertexList();
    }

    private static /* synthetic */ boolean lambda$findCounterExamplePath$0(ShortestPathAlgorithm pathFinder, State lastState, State root) {
        return pathFinder.getPath((Object)root, (Object)lastState) != null;
    }

    public static enum Type {
        COUNTER_EXAMPLE_FOUND,
        LTL_COUNTER_EXAMPLE_FOUND,
        EXCEEDED_MAX_STEPS,
        VERIFIED,
        ABORTED,
        UNKNOWN;

    }
}

