/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker;

import com.microsoft.z3.Context;
import com.microsoft.z3.Model;
import de.bmoth.backend.Abortable;
import de.bmoth.backend.TranslationOptions;
import de.bmoth.backend.z3.MachineToZ3Translator;
import de.bmoth.modelchecker.ModelCheckingResult;
import de.bmoth.modelchecker.State;
import de.bmoth.parser.ast.nodes.MachineNode;

public abstract class ModelChecker
implements Abortable {
    private Context ctx = new Context();
    private MachineToZ3Translator machineTranslator;
    private volatile boolean isAborted;

    protected ModelChecker(MachineNode machine) {
        this.machineTranslator = new MachineToZ3Translator(machine, this.ctx);
    }

    public final ModelCheckingResult check() {
        this.isAborted = false;
        return this.doModelCheck();
    }

    @Override
    public void abort() {
        this.isAborted = true;
    }

    protected boolean isAborted() {
        return this.isAborted;
    }

    protected Context getContext() {
        return this.ctx;
    }

    protected MachineToZ3Translator getMachineTranslator() {
        return this.machineTranslator;
    }

    protected abstract ModelCheckingResult doModelCheck();

    protected State getStateFromModel(Model model, TranslationOptions ops) {
        return new State(this.getMachineTranslator().getVarMapFromModel(model, ops));
    }
}

