/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3;

import com.google.common.collect.Streams;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.TupleSort;
import de.bmoth.backend.SubstitutionOptions;
import de.bmoth.backend.TranslationOptions;
import de.bmoth.backend.z3.AstTransformationsForZ3;
import de.bmoth.backend.z3.FormulaToZ3Translator;
import de.bmoth.backend.z3.Z3TypeInference;
import de.bmoth.parser.ast.nodes.AnySubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesElementOfSubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesSuchThatSubstitutionNode;
import de.bmoth.parser.ast.nodes.ConditionSubstitutionNode;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IfSubstitutionNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.OperationNode;
import de.bmoth.parser.ast.nodes.ParallelSubstitutionNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.SelectSubstitutionNode;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SkipSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import de.bmoth.parser.ast.visitors.SubstitutionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MachineToZ3Translator {
    private final MachineNode machineNode;
    private final Context z3Context;
    private final SubstitutionToZ3TranslatorVisitor visitor;
    private final Z3TypeInference z3TypeInference;
    private final Expr[] originalVariables;
    private TupleSort tuple;

    public MachineToZ3Translator(MachineNode machineNode, Context ctx) {
        this.machineNode = AstTransformationsForZ3.transformMachineNode(machineNode);
        this.z3Context = ctx;
        this.visitor = new SubstitutionToZ3TranslatorVisitor();
        this.z3TypeInference = new Z3TypeInference();
        this.originalVariables = (Expr[])this.getVariables().stream().map(this::getVariable).toArray(Expr[]::new);
        this.z3TypeInference.visitMachineNode(machineNode);
    }

    private List<BoolExpr> visitOperations(SubstitutionOptions ops) {
        ArrayList<BoolExpr> results = new ArrayList<BoolExpr>();
        if (!this.machineNode.getOperations().isEmpty()) {
            for (OperationNode operationNode : this.machineNode.getOperations()) {
                BoolExpr body = null;
                List allParams = Streams.concat((Stream[])new Stream[]{operationNode.getOutputParams().stream(), operationNode.getParams().stream()}).collect(Collectors.toList());
                if (!allParams.isEmpty()) {
                    Expr[] parameters = new Expr[allParams.size()];
                    for (int i = 0; i < parameters.length; ++i) {
                        parameters[i] = this.getVariableAsZ3Expression((DeclarationNode)allParams.get(i));
                    }
                    BoolExpr sub = (BoolExpr)this.visitor.visitSubstitutionNode(operationNode.getSubstitution(), ops);
                    body = this.z3Context.mkExists(parameters, (Expr)sub, parameters.length, null, null, null, null);
                } else {
                    body = (BoolExpr)this.visitor.visitSubstitutionNode(operationNode.getSubstitution(), ops);
                }
                HashSet<DeclarationNode> set = new HashSet<DeclarationNode>(this.getVariables());
                set.removeAll(operationNode.getSubstitution().getAssignedVariables());
                List<BoolExpr> dummyAssignments = this.createDummyAssignment(set, ops);
                dummyAssignments.add(0, body);
                BoolExpr[] array = dummyAssignments.toArray(new BoolExpr[dummyAssignments.size()]);
                results.add(this.z3Context.mkAnd(array));
            }
        } else {
            HashSet<DeclarationNode> set = new HashSet<DeclarationNode>(this.getVariables());
            List<BoolExpr> dummyAssignments = this.createDummyAssignment(set, ops);
            BoolExpr[] array = dummyAssignments.toArray(new BoolExpr[dummyAssignments.size()]);
            results.add(this.z3Context.mkAnd(array));
        }
        return results;
    }

    protected List<BoolExpr> createDummyAssignment(Set<DeclarationNode> unassignedVariables, SubstitutionOptions ops) {
        ArrayList<BoolExpr> list = new ArrayList<BoolExpr>();
        for (DeclarationNode node : unassignedVariables) {
            BoolExpr mkEq = this.z3Context.mkEq(this.getPrimedVariable(node, ops.getLhs()), this.getPrimedVariable(node, ops.getRhs()));
            list.add(mkEq);
        }
        return list;
    }

    public Z3TypeInference getZ3TypeInference() {
        return this.z3TypeInference;
    }

    public List<DeclarationNode> getVariables() {
        return this.machineNode.getVariables();
    }

    public List<DeclarationNode> getConstants() {
        return this.machineNode.getConstants();
    }

    public Expr getVariableAsZ3Expression(DeclarationNode node) {
        Sort type = this.z3TypeInference.getZ3Sort(node, this.z3Context);
        return this.z3Context.mkConst(node.getName(), type);
    }

    public Expr getVariable(DeclarationNode node) {
        Sort type = this.z3TypeInference.getZ3Sort(node, this.z3Context);
        return this.z3Context.mkConst(node.getName(), type);
    }

    public Expr getPrimedVariable(DeclarationNode node, TranslationOptions ops) {
        String primedName = this.getPrimedName(node.getName(), ops);
        Sort type = this.z3TypeInference.getZ3Sort(node, this.z3Context);
        return this.z3Context.mkConst(primedName, type);
    }

    public BoolExpr getInitialValueConstraint(TranslationOptions ops) {
        BoolExpr initialization = null;
        BoolExpr properties = null;
        if (this.machineNode.getInitialisation() != null) {
            initialization = (BoolExpr)this.visitor.visitSubstitutionNode(this.machineNode.getInitialisation(), new SubstitutionOptions(ops, TranslationOptions.UNPRIMED));
        }
        if (this.machineNode.getProperties() != null) {
            properties = FormulaToZ3Translator.translatePredicate(this.machineNode.getProperties(), this.z3Context, this.z3TypeInference);
        }
        if (initialization != null && properties != null) {
            return this.z3Context.mkAnd(new BoolExpr[]{initialization, properties});
        }
        if (initialization != null) {
            return initialization;
        }
        return properties;
    }

    public BoolExpr getInitialValueConstraint() {
        return this.getInitialValueConstraint(TranslationOptions.PRIMED_0);
    }

    private BoolExpr translatePredicate(PredicateNode predicateNode, TranslationOptions ops) {
        BoolExpr predicate = FormulaToZ3Translator.translatePredicate(predicateNode, this.z3Context, ops, this.z3TypeInference);
        return this.substituteWithPrimedIfNecessary(predicate, ops);
    }

    private BoolExpr substituteWithPrimedIfNecessary(BoolExpr boolExpr, TranslationOptions ops) {
        if (ops.isHasPrimeLevel()) {
            Expr[] primedVariables = (Expr[])this.getVariables().stream().map(var -> this.getPrimedVariable((DeclarationNode)var, ops)).toArray(Expr[]::new);
            return (BoolExpr)boolExpr.substitute(this.originalVariables, primedVariables);
        }
        return boolExpr;
    }

    public BoolExpr getInvariantConstraint(TranslationOptions ops) {
        PredicateNode invariantPredicate = this.machineNode.getInvariant();
        if (invariantPredicate != null) {
            return this.translatePredicate(invariantPredicate, ops);
        }
        return this.z3Context.mkTrue();
    }

    public BoolExpr getInvariantConstraint() {
        return this.getInvariantConstraint(TranslationOptions.UNPRIMED);
    }

    public BoolExpr getNegatedInvariantConstraint(TranslationOptions ops) {
        PredicateNode invariantPredicate = this.machineNode.getInvariant().getNegatedPredicateNode();
        if (invariantPredicate != null) {
            return this.translatePredicate(invariantPredicate, ops);
        }
        return this.z3Context.mkTrue();
    }

    public BoolExpr getNegatedInvariantConstraint() {
        return this.getNegatedInvariantConstraint(TranslationOptions.UNPRIMED);
    }

    public List<BoolExpr> getOperationConstraints(SubstitutionOptions ops) {
        return this.visitOperations(ops);
    }

    public List<BoolExpr> getOperationConstraints() {
        return this.visitOperations(new SubstitutionOptions(TranslationOptions.PRIMED_0, TranslationOptions.UNPRIMED));
    }

    public BoolExpr getCombinedOperationConstraint(SubstitutionOptions ops) {
        BoolExpr[] operations = this.visitOperations(ops).toArray(new BoolExpr[0]);
        switch (operations.length) {
            case 0: {
                return this.z3Context.mkTrue();
            }
            case 1: {
                return operations[0];
            }
        }
        return this.z3Context.mkOr(operations);
    }

    public BoolExpr getCombinedOperationConstraint() {
        return this.getCombinedOperationConstraint(new SubstitutionOptions(TranslationOptions.PRIMED_0, TranslationOptions.UNPRIMED));
    }

    public Map<String, Expr> getVarMapFromModel(Model model, TranslationOptions ops) {
        Expr value;
        Expr expr;
        HashMap<String, Expr> map = new HashMap<String, Expr>();
        for (DeclarationNode declNode : this.getVariables()) {
            expr = this.getPrimedVariable(declNode, ops);
            value = model.eval(expr, true);
            map.put(declNode.getName(), value);
        }
        for (DeclarationNode declarationNode : this.getConstants()) {
            expr = this.getVariable(declarationNode);
            value = model.eval(expr, true);
            map.put(declarationNode.getName(), value);
        }
        return map;
    }

    public BoolExpr getDistinctVars(int from, int to) {
        if (this.tuple == null) {
            Expr[] variables = (Expr[])this.getVariables().stream().map(this::getVariable).toArray(Expr[]::new);
            Symbol[] symbols = (Symbol[])Arrays.stream(variables).map(var -> var.getFuncDecl().getName()).toArray(Symbol[]::new);
            Sort[] sorts = (Sort[])Arrays.stream(variables).map(Expr::getSort).toArray(Sort[]::new);
            this.tuple = this.z3Context.mkTupleSort((Symbol)this.z3Context.mkSymbol("tuple"), symbols, sorts);
        }
        Expr[] distinct = new Expr[to - from + 1];
        int v = from;
        int i = 0;
        while (v <= to) {
            int finalV = v++;
            Expr[] vector = (Expr[])this.getVariables().stream().map(var -> this.getPrimedVariable((DeclarationNode)var, new TranslationOptions(finalV))).toArray(Expr[]::new);
            distinct[i] = this.tuple.mkDecl().apply(vector);
            ++i;
        }
        return this.z3Context.mkDistinct(distinct);
    }

    private String getPrimedName(String name, TranslationOptions ops) {
        if (ops.isHasPrimeLevel()) {
            return name + "'" + ops.getPrimeLevel();
        }
        return name;
    }

    class SubstitutionToZ3TranslatorVisitor
    implements SubstitutionVisitor<BoolExpr, SubstitutionOptions> {
        private static final String CURRENTLY_NOT_SUPPORTED = "Currently not supported";

        SubstitutionToZ3TranslatorVisitor() {
        }

        @Override
        public BoolExpr visitAnySubstitution(AnySubstitutionNode node, SubstitutionOptions ops) {
            Expr[] parameters = new Expr[node.getParameters().size()];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = MachineToZ3Translator.this.getVariableAsZ3Expression(node.getParameters().get(i));
            }
            BoolExpr parameterConstraints = FormulaToZ3Translator.translatePredicate(node.getWherePredicate(), MachineToZ3Translator.this.z3Context, MachineToZ3Translator.this.z3TypeInference);
            BoolExpr transition = (BoolExpr)this.visitSubstitutionNode(node.getThenSubstitution(), ops);
            BoolExpr existsBody = MachineToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{parameterConstraints, transition});
            return MachineToZ3Translator.this.z3Context.mkExists(parameters, (Expr)existsBody, parameters.length, null, null, null, null);
        }

        @Override
        public BoolExpr visitSelectSubstitutionNode(SelectSubstitutionNode node, SubstitutionOptions ops) {
            if (node.getConditions().size() > 1 || !(node.getElseSubstitution() instanceof SkipSubstitutionNode)) {
                throw new AssertionError((Object)CURRENTLY_NOT_SUPPORTED);
            }
            BoolExpr condition = MachineToZ3Translator.this.translatePredicate(node.getConditions().get(0), ops.getRhs());
            BoolExpr substitution = (BoolExpr)this.visitSubstitutionNode(node.getSubstitutions().get(0), ops);
            return MachineToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{condition, substitution});
        }

        @Override
        public BoolExpr visitSingleAssignSubstitution(SingleAssignSubstitutionNode node, SubstitutionOptions ops) {
            String name = MachineToZ3Translator.this.getPrimedName(node.getIdentifier().getName(), ops.getLhs());
            BoolExpr assignment = FormulaToZ3Translator.translateVariableEqualToExpr(name, node.getValue(), MachineToZ3Translator.this.z3Context, MachineToZ3Translator.this.z3TypeInference);
            return MachineToZ3Translator.this.substituteWithPrimedIfNecessary(assignment, ops.getRhs());
        }

        @Override
        public BoolExpr visitParallelSubstitutionNode(ParallelSubstitutionNode node, SubstitutionOptions ops) {
            List<SubstitutionNode> substitutions = node.getSubstitutions();
            BoolExpr boolExpr = null;
            for (SubstitutionNode substitutionNode : substitutions) {
                BoolExpr temp = (BoolExpr)this.visitSubstitutionNode(substitutionNode, ops);
                if (boolExpr == null) {
                    boolExpr = temp;
                    continue;
                }
                boolExpr = MachineToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{boolExpr, temp});
            }
            return boolExpr;
        }

        @Override
        public BoolExpr visitConditionSubstitutionNode(ConditionSubstitutionNode node, SubstitutionOptions ops) {
            BoolExpr condition = MachineToZ3Translator.this.translatePredicate(node.getCondition(), ops.getRhs());
            BoolExpr substitution = (BoolExpr)this.visitSubstitutionNode(node.getSubstitution(), ops);
            return MachineToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{condition, substitution});
        }

        @Override
        public BoolExpr visitBecomesElementOfSubstitutionNode(BecomesElementOfSubstitutionNode node, SubstitutionOptions ops) {
            if (node.getIdentifiers().size() > 1) {
                throw new AssertionError((Object)CURRENTLY_NOT_SUPPORTED);
            }
            IdentifierExprNode identifierExprNode = node.getIdentifiers().get(0);
            String name = MachineToZ3Translator.this.getPrimedName(identifierExprNode.getName(), ops.getLhs());
            return FormulaToZ3Translator.translateVariableElementOfSetExpr(name, identifierExprNode.getDeclarationNode(), node.getExpression(), MachineToZ3Translator.this.z3Context, TranslationOptions.UNPRIMED, MachineToZ3Translator.this.z3TypeInference);
        }

        @Override
        public BoolExpr visitBecomesSuchThatSubstitutionNode(BecomesSuchThatSubstitutionNode node, SubstitutionOptions ops) {
            throw new AssertionError((Object)CURRENTLY_NOT_SUPPORTED);
        }

        @Override
        public BoolExpr visitIfSubstitutionNode(IfSubstitutionNode node, SubstitutionOptions ops) {
            if (node.getConditions().size() > 1) {
                throw new AssertionError((Object)CURRENTLY_NOT_SUPPORTED);
            }
            BoolExpr condition = MachineToZ3Translator.this.translatePredicate(node.getConditions().get(0), ops.getRhs());
            BoolExpr substitution = (BoolExpr)this.visitSubstitutionNode(node.getSubstitutions().get(0), ops);
            ArrayList<BoolExpr> ifThenList = new ArrayList<BoolExpr>();
            ifThenList.add(condition);
            ifThenList.add(substitution);
            HashSet<DeclarationNode> set = new HashSet<DeclarationNode>(node.getAssignedVariables());
            set.removeAll(node.getSubstitutions().get(0).getAssignedVariables());
            ifThenList.addAll(MachineToZ3Translator.this.createDummyAssignment(set, ops));
            BoolExpr ifThen = MachineToZ3Translator.this.z3Context.mkAnd(ifThenList.toArray(new BoolExpr[ifThenList.size()]));
            BoolExpr elseExpr = null;
            ArrayList<Object> elseList = new ArrayList<Object>();
            elseList.add(MachineToZ3Translator.this.z3Context.mkNot(condition));
            if (null == node.getElseSubstitution()) {
                elseList.addAll(MachineToZ3Translator.this.createDummyAssignment(node.getAssignedVariables(), ops));
            } else {
                elseList.add(this.visitSubstitutionNode(node.getElseSubstitution(), ops));
                HashSet<DeclarationNode> elseDummies = new HashSet<DeclarationNode>(node.getAssignedVariables());
                elseDummies.removeAll(node.getElseSubstitution().getAssignedVariables());
                elseList.addAll(MachineToZ3Translator.this.createDummyAssignment(elseDummies, ops));
            }
            elseExpr = MachineToZ3Translator.this.z3Context.mkAnd(elseList.toArray(new BoolExpr[elseList.size()]));
            return MachineToZ3Translator.this.z3Context.mkOr(new BoolExpr[]{ifThen, elseExpr});
        }

        @Override
        public BoolExpr visitSkipSubstitutionNode(SkipSubstitutionNode node, SubstitutionOptions ops) {
            return MachineToZ3Translator.this.z3Context.mkBool(true);
        }
    }
}

