/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.ltl.transformation;

import de.bmoth.backend.ltl.LTLTransformationUtil;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.parser.ast.visitors.ASTTransformation;

public class ConvertNotUntil
implements ASTTransformation {
    @Override
    public boolean canHandleNode(Node node) {
        return LTLTransformationUtil.isOperator(node, LTLPrefixOperatorNode.Kind.NOT) && LTLTransformationUtil.contains(node, LTLInfixOperatorNode.Kind.UNTIL);
    }

    @Override
    public Node transformNode(Node oldNode) {
        LTLPrefixOperatorNode notOperator = (LTLPrefixOperatorNode)oldNode;
        LTLNode argument = notOperator.getArgument();
        LTLInfixOperatorNode untilOperator = (LTLInfixOperatorNode)argument;
        LTLNode left = untilOperator.getLeft();
        LTLNode right = untilOperator.getRight();
        LTLPrefixOperatorNode notRight = new LTLPrefixOperatorNode(LTLPrefixOperatorNode.Kind.NOT, right);
        LTLPrefixOperatorNode notLeft = new LTLPrefixOperatorNode(LTLPrefixOperatorNode.Kind.NOT, left);
        return new LTLInfixOperatorNode(LTLInfixOperatorNode.Kind.RELEASE, notLeft, notRight);
    }
}

