/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import de.bmoth.app.OptionViewModel;
import de.saxsys.mvvmfx.FxmlView;
import de.saxsys.mvvmfx.InjectViewModel;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class OptionView
implements FxmlView<OptionViewModel>,
Initializable {
    @InjectViewModel
    OptionViewModel optionViewModel;
    @FXML
    Button cancelButton;
    @FXML
    Button okButton;
    @FXML
    Button applyButton;
    @FXML
    TextField minInt;
    @FXML
    TextField maxInt;
    @FXML
    TextField maxInitState;
    @FXML
    TextField maxTrans;
    @FXML
    TextField z3Timeout;
    private Alert preferenceVerificationErrorAlert;

    public void initialize(URL location, ResourceBundle resources) {
        this.optionViewModel.loadPrefs();
        this.minInt.textProperty().bindBidirectional((Property)this.optionViewModel.getMinInt());
        this.maxInt.textProperty().bindBidirectional((Property)this.optionViewModel.getMaxInt());
        this.maxInitState.textProperty().bindBidirectional((Property)this.optionViewModel.getMaxInitState());
        this.maxTrans.textProperty().bindBidirectional((Property)this.optionViewModel.getMaxTrans());
        this.z3Timeout.textProperty().bindBidirectional((Property)this.optionViewModel.getZ3Timeout());
        this.preferenceVerificationErrorAlert = new Alert(Alert.AlertType.ERROR);
        this.optionViewModel.getAlertText().bind((ObservableValue)this.preferenceVerificationErrorAlert.contentTextProperty());
    }

    boolean checkPrefs() {
        if (!this.optionViewModel.checkPrefs()) {
            this.preferenceVerificationErrorAlert.show();
            return false;
        }
        return true;
    }

    public void handleApply() {
        if (this.checkPrefs()) {
            this.optionViewModel.savePrefs();
        }
    }

    public void handleClose() {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    public void handleOk() {
        if (this.checkPrefs()) {
            this.optionViewModel.savePrefs();
            this.handleClose();
        }
    }
}

