/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class Highlighter {
    private static final String[] START = new String[]{"MACHINE"};
    private static final String[] KEYWORDS = new String[]{"VARIABLES", "DEFINITIONS", "INVARIANT", "INITIALISATION", "OPERATIONS", "CONSTANTS", "PROPERTIES", "SETS"};
    private static final String[] KEYWORDS2 = new String[]{"END", "SELECT", "THEN", "BEGIN", "WHERE", "ANY"};
    private static final String START_PATTERN = "\\b(" + String.join((CharSequence)"|", START) + ")\\b";
    private static final String KEYWORD_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS) + ")\\b";
    private static final String KEYWORD2_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS2) + ")\\b";
    private static final String PAREN_PATTERN = "\\(|\\)";
    private static final String BRACE_PATTERN = "\\{|\\}";
    private static final String BRACKET_PATTERN = "\\[|\\]";
    private static final String SEMICOLON_PATTERN = "\\;";
    private static final String STRING_PATTERN = "\"([^\"\\\\]|\\\\.)*\"";
    private static final String COMMENT_PATTERN = "//[^\n]*|/\\*(.|\\R)*?\\*/";
    private static final Pattern PATTERN = Pattern.compile("(?<KEYWORD>" + KEYWORD_PATTERN + ")" + "|(?<START>" + START_PATTERN + ")" + "|(?<KEYWORD2>" + KEYWORD2_PATTERN + ")" + "|(?<PAREN>" + "\\(|\\)" + ")" + "|(?<BRACE>" + "\\{|\\}" + ")" + "|(?<BRACKET>" + "\\[|\\]" + ")" + "|(?<SEMICOLON>" + "\\;" + ")" + "|(?<STRING>" + "\"([^\"\\\\]|\\\\.)*\"" + ")" + "|(?<COMMENT>" + "//[^\n]*|/\\*(.|\\R)*?\\*/" + ")");

    private Highlighter() {
    }

    protected static StyleSpans<Collection<String>> computeHighlighting(String text) {
        String[] groups = new String[]{"START", "KEYWORD", "KEYWORD2", "PAREN", "BRACE", "BRACKET", "SEMICOLON", "STRING", "COMMENT"};
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass = null;
            for (String group : groups) {
                if (matcher.group(group) == null) continue;
                styleClass = group.toLowerCase();
                break;
            }
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

