/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.validators;

import de.prob.core.LanguageDependendAnimationPart;
import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.ProBParserBaseAdapter;
import org.eclipse.jface.dialogs.IInputValidator;

public final class PredicateValidator
implements IInputValidator {
    final LanguageDependendAnimationPart ldp;

    public PredicateValidator(LanguageDependendAnimationPart ldp) {
        this.ldp = ldp;
    }

    public String isValid(String newText) {
        if (newText.trim().isEmpty()) {
            return null;
        }
        if (this.ldp == null) {
            return "Cannot parse predicates for the current formalism";
        }
        try {
            ProBParserBaseAdapter parser = new ProBParserBaseAdapter((ProBParserBase)this.ldp);
            parser.parsePredicate(newText, false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return "The parser for this formalism cannot parse predicates";
        }
        catch (ProBParseException e) {
            return e.getLocalizedMessage();
        }
        return null;
    }
}

