/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview.statetree;

import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.EvaluationStateElement;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.ui.stateview.statetree.AbstractStateTreeElement;
import de.prob.ui.stateview.statetree.EStateTreeElementProperty;
import de.prob.ui.stateview.statetree.StateDependendElement;
import de.prob.ui.stateview.statetree.StateTreeElement;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StateTreeExpression
extends AbstractStateTreeElement {
    private final EvaluationElement staticElement;
    private List<StateTreeElement> children = null;

    public StateTreeExpression(StaticStateElement parent, EvaluationElement staticElement) {
        super(parent);
        this.staticElement = staticElement;
    }

    @Override
    public StaticStateElement[] getChildren() {
        this.checkForChildren();
        return this.children.toArray(StateTreeElement.EMPTY_ARRAY);
    }

    private void checkForChildren() {
        if (this.children == null) {
            try {
                EvaluationElement[] staticChildren = this.staticElement.getChildren();
                this.children = new ArrayList<StateTreeElement>(staticChildren.length);
                EvaluationElement[] evaluationElementArray = staticChildren;
                int n = staticChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    EvaluationElement sChild = evaluationElementArray[n2];
                    StateTreeExpression dChild = new StateTreeExpression(this, sChild);
                    this.children.add(dChild);
                    ++n2;
                }
            }
            catch (ProBException e) {
                e.notifyUserOnce();
                this.children = Collections.emptyList();
            }
        }
    }

    @Override
    public String getLabel() {
        try {
            return this.staticElement.getLabel();
        }
        catch (ProBException e) {
            e.notifyUserOnce();
            return null;
        }
    }

    @Override
    public boolean hasChildren() {
        this.checkForChildren();
        return !this.children.isEmpty();
    }

    @Override
    public boolean hasChanged(State current, State last) {
        String lastval;
        String curval;
        try {
            curval = this.getResultString(current);
            lastval = this.getResultString(last);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
            return false;
        }
        return !Objects.equals(curval, lastval);
    }

    private String getResultString(State state) throws ProBException {
        EvaluationStateElement dyn = EvaluationGetValuesCommand.getSingleValueCached((State)state, (EvaluationElement)this.staticElement);
        EvaluationGetValuesCommand.EvaluationResult res = dyn == null ? null : dyn.getResult();
        return res == null ? null : res.getText();
    }

    public EvaluationElement getStaticElement() {
        return this.staticElement;
    }

    @Override
    public StateDependendElement getValue(State state) {
        StateDependendElement sd;
        try {
            EvaluationStateElement dynamicElement = EvaluationGetValuesCommand.getSingleValueCached((State)state, (EvaluationElement)this.staticElement);
            EStateTreeElementProperty property = EStateTreeElementProperty.INACTIVE;
            String value = "?";
            if (dynamicElement != null) {
                EvaluationGetValuesCommand.EvaluationResult result = dynamicElement.getResult();
                if (result.isActive()) {
                    property = result.hasError() ? EStateTreeElementProperty.ERROR : (result.isPredicate() ? (result.isPredicateTrue() ? EStateTreeElementProperty.TRUE : EStateTreeElementProperty.FALSE) : EStateTreeElementProperty.NONBOOLEAN);
                }
                value = result.getText();
            }
            sd = new StateDependendElement(state, value, property);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
            sd = new StateDependendElement(state, "(internal error)", EStateTreeElementProperty.ERROR);
        }
        return sd;
    }
}

