/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.ui.ProbUiPlugin;
import de.prob.ui.historyview.HistoryView;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowInHistoryHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            ArrayList<StaticStateElement> sses = new ArrayList<StaticStateElement>();
            for (Object element : sel.toList()) {
                if (!(element instanceof StaticStateElement)) continue;
                sses.add((StaticStateElement)element);
            }
            if (!sses.isEmpty()) {
                this.addToHistory(sses);
            }
        }
        return null;
    }

    private void addToHistory(Collection<StaticStateElement> sses) {
        IWorkbenchWindow window = ProbUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        HistoryView view = this.findHistoryView(window);
        if (view != null) {
            HistoryView hview = view;
            hview.addColumns(sses);
        }
    }

    private HistoryView findHistoryView(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        IViewPart view = page.findView("de.prob.ui.HistoryView");
        if (view == null) {
            try {
                view = page.showView("de.prob.ui.HistoryView");
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)window.getShell(), (String)"Internal Error", (String)"Error while opening the History View");
            }
        }
        if (view == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Internal Error", (String)"Cannot not find the History View");
            return null;
        }
        if (view instanceof HistoryView) {
            return (HistoryView)view;
        }
        MessageDialog.openError((Shell)window.getShell(), (String)"Internal Error", (String)("Not expected type of the History View: " + view.getClass().getName()));
        return null;
    }
}

