/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.domainobjects.Operation;
import de.prob.ui.operationview.OperationTableViewer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class ParameterMenu
extends ExtensionContributionFactory {
    private int nondetcounter;

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        List<Operation> operations = OperationTableViewer.getInstance().getSelectedOperations();
        if (operations.isEmpty()) {
            return;
        }
        this.nondetcounter = 0;
        if (operations.size() <= 10) {
            for (Operation operation : operations) {
                long id = operation.getId();
                additions.addContributionItem((IContributionItem)this.createEntry(serviceLocator, operation, id), null);
            }
        }
        CommandContributionItemParameter contributionParameters = new CommandContributionItemParameter(serviceLocator, "", "de.prob.ui.show_parameter_dialog", 8);
        contributionParameters.label = "Show Parameter Dialog ...";
        CommandContributionItem dialogItem = new CommandContributionItem(contributionParameters);
        additions.addContributionItem((IContributionItem)dialogItem, null);
        CommandContributionItemParameter contributionCustomGuard = new CommandContributionItemParameter(serviceLocator, "", "de.prob.ui.show_custom_precondition_dialog", 8);
        contributionCustomGuard.label = "Execute with additional Guard Constraint ...";
        CommandContributionItem customGuardDialogItem = new CommandContributionItem(contributionCustomGuard);
        additions.addContributionItem((IContributionItem)customGuardDialogItem, null);
        if (operations.size() > 10) {
            for (Operation operation : operations) {
                long id = operation.getId();
                additions.addContributionItem((IContributionItem)this.createEntry(serviceLocator, operation, id), null);
            }
        }
    }

    private CommandContributionItem createEntry(IServiceLocator serviceLocator, Operation op, long id) {
        Object itemText = op.getArguments() != null && op.getArguments().size() > 0 ? OperationTableViewer.convertParamsToString(15, 25, op.getArguments()) : "Non-deterministic choice #" + ++this.nondetcounter;
        CommandContributionItemParameter p = new CommandContributionItemParameter(serviceLocator, "", "de.prob.ui.execute_event", 8);
        p.label = itemText;
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("de.prob.ui.operation", Long.toString(id));
        p.parameters = map;
        CommandContributionItem item = new CommandContributionItem(p);
        item.setVisible(true);
        return item;
    }
}

