/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.LimitedLogger;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.GetOperationNamesCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.OperationInfo;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.operationview.OperationsContentProvider;
import de.prob.ui.operationview.OperationsLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class OperationTableViewer {
    private static DoubleClickBehaviour doubleClickBehaviour = DoubleClickBehaviour.NORMAL;
    private static OperationTableViewer instance;
    private final Collection<String> operationNames = this.getAllOperations();
    private final TableViewer viewer;
    private static final ViewerFilter DISABLED_OPS_FILTER;
    private TableColumnLayout layout;

    static {
        DISABLED_OPS_FILTER = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof ArrayList;
            }
        };
    }

    private OperationTableViewer(Composite parent, int style) {
        parent.addDisposeListener((DisposeListener)new TableDisposedListener());
        this.viewer = new TableViewer(parent, style);
        this.createColumns(parent);
        this.viewer.setContentProvider((IContentProvider)new OperationsContentProvider(this.operationNames));
        this.viewer.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider(this));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new OTVDoubleClickListener());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private Collection<String> getAllOperations() {
        List<String> list = new ArrayList<String>();
        try {
            list = OperationInfo.extractNames((Collection)GetOperationNamesCommand.getNames((Animator)Animator.getAnimator()));
        }
        catch (ProBException proBException) {}
        return list;
    }

    public void refresh() {
        this.viewer.refresh();
        this.packTableColumns();
    }

    private void createColumns(Composite parent) {
        this.layout = new TableColumnLayout();
        parent.setLayout((Layout)this.layout);
        TableViewerColumn column1 = new TableViewerColumn(this.viewer, 0);
        column1.getColumn().setText("Event");
        column1.getColumn().setResizable(true);
        column1.getColumn().pack();
        TableViewerColumn column2 = new TableViewerColumn(this.viewer, 0);
        column2.getColumn().setText("Parameter(s)");
        column2.getColumn().setResizable(true);
        column2.getColumn().pack();
        this.layout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, column1.getColumn().getWidth()));
        this.layout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, column2.getColumn().getWidth()));
    }

    private void packTableColumns() {
        this.viewer.getTable().getColumns()[0].pack();
    }

    public List<Operation> getSelectedOperations() {
        IStructuredSelection ssel;
        if (this.viewer.getSelection() != null && this.viewer.getSelection() instanceof IStructuredSelection && (ssel = (IStructuredSelection)this.viewer.getSelection()).getFirstElement() instanceof ArrayList) {
            return (List)ssel.getFirstElement();
        }
        return Collections.emptyList();
    }

    private void executeRandomOperation() {
        List<Operation> selectedOperations = this.getSelectedOperations();
        int use = new Random().nextInt(selectedOperations.size());
        this.executeSingleOperation(use);
    }

    private void executeSingleOperation(int index) {
        try {
            ExecuteOperationCommand.executeOperation((Animator)Animator.getAnimator(), (Operation)this.getSelectedOperations().get(index));
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
    }

    public static String convertParamsToString(int argLength, int totalLength, List<String> params) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String parameter : params) {
            int length;
            if (!first) {
                sb.append(", ");
            }
            if ((length = parameter.length()) > argLength) {
                if (argLength > 6) {
                    sb.append(parameter.substring(0, argLength - 3));
                }
                sb.append("...");
            } else {
                sb.append(parameter);
            }
            first = false;
        }
        Object result = sb.toString();
        if (((String)result).length() >= totalLength) {
            result = ((String)result).substring(0, totalLength) + " [...]";
        }
        return result;
    }

    public static void setDoubleClickBehavior(String behavior) {
        doubleClickBehaviour = DoubleClickBehaviour.valueOf(behavior);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public static OperationTableViewer create(Composite pageComposite, int i) {
        if (instance == null) {
            instance = new OperationTableViewer(pageComposite, i);
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand("de.prob.ui.filter_enabled_only");
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            if (state == null) {
                instance.unapplyFilter();
            } else if (((Boolean)state.getValue()).booleanValue()) {
                instance.applyFilter();
            } else {
                instance.unapplyFilter();
            }
        }
        return instance;
    }

    public static OperationTableViewer getInstance() {
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public void applyFilter() {
        this.getViewer().setFilters(new ViewerFilter[]{DISABLED_OPS_FILTER});
    }

    public void unapplyFilter() {
        this.getViewer().resetFilters();
    }

    public static enum DoubleClickBehaviour {
        NORMAL,
        RANDOM,
        DIALOG;

    }

    private class OTVDoubleClickListener
    implements IDoubleClickListener {
        private OTVDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!OperationTableViewer.this.getSelectedOperations().isEmpty()) {
                LimitedLogger.getLogger().log("user chooses event", null, null);
                switch (doubleClickBehaviour) {
                    case NORMAL: {
                        OperationTableViewer.this.executeSingleOperation(0);
                        break;
                    }
                    case RANDOM: {
                        OperationTableViewer.this.executeRandomOperation();
                        break;
                    }
                    case DIALOG: {
                        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        try {
                            service.executeCommand("de.prob.ui.show_parameter_dialog", null);
                            break;
                        }
                        catch (Exception exception) {
                            Logger.assertFail((String)"Exception when calling Handler Service");
                        }
                    }
                }
            }
        }
    }

    private class TableDisposedListener
    implements DisposeListener {
        private TableDisposedListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            OperationTableViewer.destroy();
        }
    }
}

