/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.Operation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class HistoryBackwardMenu
extends ExtensionContributionFactory {
    private final Stack<CommandContributionItem> items = new Stack();

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        Animator animator = Animator.getAnimator();
        History history = animator.getHistory();
        if (history.isEmpty()) {
            return;
        }
        int pos = 0;
        String lastItem = "(root)";
        Iterator iterator = history.iterator();
        int currentPosition = history.getCurrentPosition();
        while (iterator.hasNext()) {
            HistoryItem historyItem = (HistoryItem)iterator.next();
            if (pos >= currentPosition) break;
            this.items.push(this.createEntry(serviceLocator, lastItem, pos));
            Operation operation = historyItem.getOperation();
            lastItem = operation != null ? operation.toString() : historyItem.getState().toString();
            ++pos;
        }
        while (!this.items.isEmpty()) {
            additions.addContributionItem((IContributionItem)this.items.pop(), null);
        }
    }

    private CommandContributionItem createEntry(IServiceLocator serviceLocator, String lastItem, int pos) {
        CommandContributionItemParameter p = new CommandContributionItemParameter(serviceLocator, "", "de.prob.ui.history.back", 8);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("de.prob.ui.history.pos", Integer.toString(pos));
        p.parameters = map;
        p.label = lastItem;
        CommandContributionItem item = new CommandContributionItem(p);
        item.setVisible(true);
        return item;
    }
}

