/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.ui.operationview.Filter;
import de.prob.ui.operationview.FilterDialog;
import de.prob.ui.operationview.FilterListener;
import de.prob.ui.operationview.StringMatcher;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FilterManager
implements SelectionListener {
    protected List<Filter> filters = new LinkedList<Filter>();
    protected Menu filtersMenu;
    protected List<FilterListener> listeners = new LinkedList<FilterListener>();
    protected MenuItem configureItem;

    public FilterManager(Menu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu can not be null");
        }
        this.filtersMenu = menu;
        this.addConfigureItem();
    }

    private void addConfigureItem() {
        new MenuItem(this.filtersMenu, 2);
        this.configureItem = new MenuItem(this.filtersMenu, 0);
        this.configureItem.setText("&Configure...");
        this.configureItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                FilterManager.this.showFilterPopup();
            }
        });
    }

    private void showFilterPopup() {
        FilterDialog filterDialog = new FilterDialog(Display.getCurrent().getActiveShell(), this.filters);
        this.clearMenu();
        this.filters = filterDialog.open();
        for (Filter filter : this.filters) {
            this.addFilterToMenu(filter);
        }
        this.filtersChanged();
    }

    private void clearMenu() {
        MenuItem[] menuItemArray = this.filtersMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter;
            MenuItem item = menuItemArray[n2];
            if (item.getData() instanceof Filter && this.filters.contains(filter = (Filter)item.getData())) {
                item.dispose();
            }
            ++n2;
        }
    }

    protected void addFilterToMenu(Filter filter) {
        MenuItem item = new MenuItem(this.filtersMenu, 32);
        item.setText(filter.getName());
        item.setSelection(filter.getEnabled().booleanValue());
        item.setData((Object)filter);
        item.addSelectionListener((SelectionListener)this);
    }

    public Filter addFilter(String pattern) {
        return this.addFilter(pattern, pattern);
    }

    public Filter addFilter(String pattern, String name) {
        Filter filter = new Filter(pattern, name, true);
        this.addFilter(filter);
        return filter;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        this.addFilterToMenu(filter);
    }

    public boolean match(String text) {
        for (Filter filter : this.filters) {
            StringMatcher stringMatcher;
            if (!filter.getEnabled().booleanValue() || !(stringMatcher = new StringMatcher(filter.getPattern(), false, false)).match(text)) continue;
            return true;
        }
        return false;
    }

    public void addFilterListener(FilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterListener(FilterListener listener) {
        this.listeners.remove(listener);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            Filter filter = (Filter)item.getData();
            filter.setEnabled(item.getSelection());
            this.filtersChanged();
        }
    }

    public void filtersChanged() {
        for (FilterListener l : this.listeners) {
            l.filtersChanged();
        }
    }
}

