/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleState;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.ui.ltl.CounterExampleViewPart;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public final class TreeColumnValueLabelProvider
extends CellLabelProvider {
    private final CounterExampleState state;
    private final Font normal = new Font((Device)Display.getDefault(), "Arial", 10, 0);
    private final Font bold = new Font((Device)Display.getDefault(), "Arial", 10, 1);

    public TreeColumnValueLabelProvider(CounterExampleState state) {
        this.state = state;
    }

    public void update(ViewerCell cell) {
        CounterExampleProposition proposition;
        if (cell != null && (proposition = (CounterExampleProposition)cell.getElement()) != null) {
            int index = this.state.getIndex();
            CounterExampleValueType value = (CounterExampleValueType)proposition.getValues().get(index);
            cell.setText(value.toString());
            CounterExampleViewPart counterExampleView = CounterExampleViewPart.getDefault();
            if (counterExampleView != null) {
                int currentIndex = counterExampleView.getCurrentIndex();
                if (index != currentIndex) {
                    cell.setFont(this.normal);
                } else {
                    cell.setFont(this.bold);
                }
            }
        }
    }
}

