/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.be4.ltl.core.parser.LtlParseException;
import de.be4.ltl.core.parser.LtlParser;
import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.command.SymmetryReductionOption;
import de.prob.logging.Logger;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.term.PrologTerm;
import de.prob.ui.DialogHelpers;
import de.prob.ui.ltl.LtlCheckingFinishedListener;
import de.prob.ui.ltl.LtlCheckingJob;
import de.prob.ui.ltl.LtlMultiCheckingFinishedListener;
import de.prob.ui.ltl.LtlStrings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class LtlCheckingDialog
extends TrayDialog {
    private static final String CONFIGURATION_ID = "de.prob.ui.ltl.CounterExampleViewPart";
    private static final StartOption[] START_MODES = new StartOption[]{new StartOption(LtlCheckingCommand.StartMode.init, "Start in the (possible several) initialisation states of the model"), new StartOption(LtlCheckingCommand.StartMode.starthere, "Start the evaluation of the formula in the current state"), new StartOption(LtlCheckingCommand.StartMode.checkhere, "Start the search as in init, but check the formula F in the current state by constructing a new formula (current -> F)")};
    private final Shell shell;
    private boolean trayOpened = false;
    private Combo formulas = null;
    private Combo startingPointOptions = null;
    private Combo symmetryOptions = null;

    public LtlCheckingDialog(Shell shell) {
        super(shell);
        this.shell = shell;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("LTL Checking");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.formulas = this.createFormulas(dialogArea);
        this.startingPointOptions = this.createStartingPointOptions(dialogArea);
        this.symmetryOptions = this.createSymmetryOptions(dialogArea);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(64));
        Button startButton = new Button(composite, 8);
        startButton.setText("Start LTL Checking");
        startButton.addSelectionListener((SelectionListener)new StartButtonSelectionListener());
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return dialogArea;
    }

    protected Control createHelpControl(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        Image image = JFaceResources.getImage((String)"dialog_help_image");
        if (image != null) {
            item.setImage(JFaceResources.getImage((String)"dialog_help_image"));
        }
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LtlCheckingDialog.this.trayOpened) {
                    LtlCheckingDialog.this.closeTray();
                } else {
                    LtlCheckingDialog.this.openTray(new DialogTray(){

                        protected Control createContents(Composite parent) {
                            StyledText help = new StyledText(parent, 8);
                            help.setEditable(false);
                            help.setEnabled(false);
                            help.setText(LtlStrings.ltlHelpText);
                            help.setBackground(Display.getDefault().getSystemColor(1));
                            return help;
                        }
                    });
                }
                LtlCheckingDialog.this.trayOpened = !LtlCheckingDialog.this.trayOpened;
            }
        });
        return toolBar;
    }

    private Combo createFormulas(Composite parent) {
        Group group = DialogHelpers.createGroup(parent, "Formula:");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Combo combo = new Combo((Composite)group, 0);
        combo.setLayoutData((Object)new GridData(768));
        for (String formula : this.getFormulas()) {
            combo.add(formula);
        }
        combo.select(0);
        Button button = new Button((Composite)group, 0);
        button.setText("Open...");
        button.addSelectionListener((SelectionListener)new OpenButtonSelectionListener());
        return combo;
    }

    private Combo createStartingPointOptions(Composite parent) {
        Group group = DialogHelpers.createGroup(parent, "Starting Point:");
        group.setLayoutData((Object)new GridData(768));
        Combo combo = new Combo((Composite)group, 8);
        combo.setLayoutData((Object)new GridData(768));
        StartOption[] startOptionArray = START_MODES;
        int n = START_MODES.length;
        int n2 = 0;
        while (n2 < n) {
            StartOption startOption = startOptionArray[n2];
            combo.add(startOption.description);
            ++n2;
        }
        combo.select(0);
        return combo;
    }

    private Combo createSymmetryOptions(Composite parent) {
        SymmetryReductionOption[] symmetryOptions;
        Group group = DialogHelpers.createGroup(parent, "Symmetry Reduction:");
        group.setLayoutData((Object)new GridData(768));
        Combo combo = new Combo((Composite)group, 8);
        combo.setLayoutData((Object)new GridData(768));
        SymmetryReductionOption[] symmetryReductionOptionArray = symmetryOptions = SymmetryReductionOption.values();
        int n = symmetryOptions.length;
        int n2 = 0;
        while (n2 < n) {
            SymmetryReductionOption startOption = symmetryReductionOptionArray[n2];
            combo.add(startOption.getDescription());
            ++n2;
        }
        combo.select(0);
        return combo;
    }

    private void saveFormulas(Set<String> formulas) {
        IEclipsePreferences configNode = ConfigurationScope.INSTANCE.getNode(CONFIGURATION_ID);
        if (configNode != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(formulas);
                objectOutputStream.flush();
                byte[] formula = byteArrayOutputStream.toByteArray();
                configNode.putByteArray("formula", formula);
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Set<String> getFormulas() {
        Set<String> formulas;
        IEclipsePreferences configNode = ConfigurationScope.INSTANCE.getNode(CONFIGURATION_ID);
        byte[] formula = null;
        if (configNode != null) {
            formula = configNode.getByteArray("formula", null);
        }
        if (formula != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(formula);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                formulas = (Set)objectInputStream.readObject();
            }
            catch (ClassNotFoundException e) {
                Logger.notifyUser((String)"Class not found exception when trying to read formulas", (Throwable)e);
                formulas = new HashSet();
            }
            catch (IOException e) {
                Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e);
                formulas = new HashSet();
            }
        } else {
            formulas = new HashSet<String>();
        }
        return formulas;
    }

    private PrologTerm parseLTLFormula(String formula) throws CommandException {
        Animator animator = Animator.getAnimator();
        PrologTerm parsedFormula = null;
        LtlParser parser = new LtlParser((ProBParserBase)animator.getLanguageDependendPart());
        try {
            parsedFormula = parser.generatePrologTerm(formula, "root");
        }
        catch (LtlParseException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Syntax error", (String)e.getLocalizedMessage());
        }
        return parsedFormula;
    }

    private void scheduleJob(PrologTerm parsedFormula, JobChangeAdapter checkingListener) {
        LtlCheckingCommand.StartMode option = LtlCheckingDialog.START_MODES[this.startingPointOptions.getSelectionIndex()].mode;
        String symmetryOption = SymmetryReductionOption.get((int)this.symmetryOptions.getSelectionIndex()).name();
        LtlCheckingJob job = new LtlCheckingJob("LTL Model Checking", parsedFormula, option, symmetryOption);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)checkingListener);
        job.schedule();
    }

    private final class OpenButtonSelectionListener
    extends SelectionAdapter {
        private OpenButtonSelectionListener() {
        }

        /*
         * Loose catch block
         */
        public void widgetSelected(SelectionEvent event) {
            FileDialog fileDialog = new FileDialog(LtlCheckingDialog.this.shell, 4096);
            fileDialog.setFilterExtensions(new String[]{"*.ltl", "*.*"});
            fileDialog.setFilterNames(new String[]{"LTL files (*.ltl)", "All files (*.*)"});
            String fileName = fileDialog.open();
            if (fileName != null) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(fileName));
                        String formula = null;
                        List<String> formulaItems = Arrays.asList(LtlCheckingDialog.this.formulas.getItems());
                        ArrayList<String> fileFormulas = new ArrayList<String>();
                        ArrayList<PrologTerm> parsedFormulas = new ArrayList<PrologTerm>();
                        while ((formula = reader.readLine()) != null) {
                            if ((formula = formula.trim()).equals("") || formula.length() > 0 && formula.charAt(0) == '#') continue;
                            PrologTerm parsedFormula = LtlCheckingDialog.this.parseLTLFormula(formula);
                            if (parsedFormula == null) break;
                            if (!formulaItems.contains(formula)) {
                                LtlCheckingDialog.this.formulas.add(formula);
                            }
                            if (fileFormulas.contains(formula)) continue;
                            fileFormulas.add(formula);
                            parsedFormulas.add(parsedFormula);
                        }
                        LtlCheckingDialog.this.saveFormulas(new TreeSet<String>(Arrays.asList(LtlCheckingDialog.this.formulas.getItems())));
                        LtlMultiCheckingFinishedListener checkingListener = new LtlMultiCheckingFinishedListener(LtlCheckingDialog.this.shell, fileFormulas);
                        for (PrologTerm parsedFormula : parsedFormulas) {
                            LtlCheckingDialog.this.scheduleJob(parsedFormula, checkingListener);
                        }
                        LtlCheckingDialog.this.formulas.select(0);
                        LtlCheckingDialog.this.close();
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        Logger.notifyUser((String)"File not found", (Throwable)e);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e2) {
                            Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e2);
                        }
                    }
                    catch (IOException e) {
                        Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e3) {
                            Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e3);
                        }
                    }
                    catch (CommandException e) {
                        Logger.notifyUser((String)"Command exception", (Throwable)e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e4) {
                            Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e4);
                        }
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.notifyUser((String)"Unexpected IO exception", (Throwable)e);
                    }
                }
            }
        }
    }

    private final class StartButtonSelectionListener
    extends SelectionAdapter {
        private StartButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            PrologTerm parsedFormula = null;
            try {
                String formula = LtlCheckingDialog.this.formulas.getText();
                parsedFormula = LtlCheckingDialog.this.parseLTLFormula(formula);
                if (parsedFormula != null) {
                    List<String> formulaItems = Arrays.asList(LtlCheckingDialog.this.formulas.getItems());
                    if (!formulaItems.contains(formula)) {
                        LtlCheckingDialog.this.formulas.add(formula);
                    }
                    LtlCheckingDialog.this.saveFormulas(new TreeSet<String>(Arrays.asList(LtlCheckingDialog.this.formulas.getItems())));
                }
            }
            catch (CommandException commandException) {
                LtlCheckingDialog.this.close();
            }
            if (parsedFormula != null) {
                LtlCheckingDialog.this.scheduleJob(parsedFormula, new LtlCheckingFinishedListener(LtlCheckingDialog.this.shell));
                LtlCheckingDialog.this.close();
            }
        }
    }

    private static final class StartOption {
        private final LtlCheckingCommand.StartMode mode;
        private final String description;

        private StartOption(LtlCheckingCommand.StartMode mode, String description) {
            this.mode = mode;
            this.description = description;
        }
    }
}

