/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleTableViewer;
import de.prob.ui.ltl.handler.CounterExampleHistoryHandler;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableItem;

public final class CounterExampleTableMouseAdapter
extends MouseAdapter {
    private final CounterExampleTableViewer tableViewer;
    private final CounterExample counterExample;

    public CounterExampleTableMouseAdapter(CounterExampleTableViewer tableViewer, CounterExample counterExample) {
        this.tableViewer = tableViewer;
        this.counterExample = counterExample;
    }

    public void mouseDoubleClick(MouseEvent event) {
        ViewerCell cell = this.tableViewer.getCell(new Point(event.x, event.y));
        if (cell != null) {
            List<TableItem> items = Arrays.asList(this.tableViewer.getTable().getItems());
            TableItem item = (TableItem)cell.getItem();
            int index = items.indexOf(item);
            index += this.counterExample.getInitPath().size();
            Animator animator = Animator.getAnimator();
            History history = animator.getHistory();
            try {
                CounterExampleHistoryHandler.showCounterExampleInAnimator();
                history.gotoPos(index);
            }
            catch (ExecutionException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
            catch (ProBException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
        }
    }
}

