/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleFigure;
import de.prob.ui.ltl.CounterExamplePropositionFigure;
import de.prob.ui.ltl.handler.CounterExampleHistoryHandler;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public final class CounterExampleBinaryFigure
extends CounterExamplePropositionFigure {
    private Panel firstPanel;
    private Panel secondPanel;
    protected final Hashtable<Ellipse, Integer> firstArgumentEllipses1 = new Hashtable();
    protected final Hashtable<Integer, Ellipse> firstArgumentEllipses2 = new Hashtable();
    private final Hashtable<Ellipse, Integer> secondArgumentEllipses1 = new Hashtable();
    private final Hashtable<Integer, Ellipse> secondArgumentEllipses2 = new Hashtable();

    public CounterExampleBinaryFigure(CounterExampleProposition model) {
        super(model);
        this.bounds = new Rectangle(50, 50, 50 * (model.getValues().size() * 2 + 1), 225);
    }

    @Override
    protected void drawProposition(CounterExamplePropositionFigure parent) {
        CounterExampleFigure counterExampleFigure = (CounterExampleFigure)this.getParent();
        Insets insets = this.getInsets();
        if (parent != null) {
            Rectangle parentBounds = parent.getBounds();
            this.bounds.x = parentBounds.x - insets.left;
            this.bounds.y = parentBounds.y + parentBounds.height + 25;
        } else {
            List<RectangleFigure> states = counterExampleFigure.getStates();
            int i = 0;
            while (i < states.size()) {
                RectangleFigure state = states.get(i);
                if (!counterExampleFigure.getChildren().contains(state)) {
                    state.setBounds(new Rectangle(100 * (i + 1) + insets.left, 50, 50, 150 + 6 * insets.top));
                    counterExampleFigure.add((IFigure)state, 0);
                }
                ++i;
            }
        }
        counterExampleFigure.setConstraint((IFigure)this, new Rectangle(this.bounds));
        this.removeAll();
        int stateId = this.model.getStateId();
        CounterExampleProposition firstArgument = ((CounterExampleBinaryOperator)this.model).getFirstArgument();
        List firstPositions = (List)((CounterExampleBinaryOperator)this.model).getFirstHighlightedPositions().get(stateId);
        Rectangle firstPanelBounds = new Rectangle(this.bounds.x + 20, this.bounds.y + 20, this.bounds.width, this.bounds.height / 2);
        this.firstPanel = this.drawPropositionFigure(parent, this.bounds, firstArgument, firstPositions, this.firstArgumentEllipses1, this.firstArgumentEllipses2, firstPanelBounds, stateId, 50);
        Rectangle secondPanelBounds = new Rectangle(this.bounds.x + 20, this.bounds.y + 120, this.bounds.width, this.bounds.height / 2);
        CounterExampleProposition secondArgument = ((CounterExampleBinaryOperator)this.model).getSecondArgument();
        List secondPositions = (List)((CounterExampleBinaryOperator)this.model).getSecondHighlightedPositions().get(stateId);
        this.secondPanel = this.drawPropositionFigure(parent, this.bounds, secondArgument, secondPositions, this.secondArgumentEllipses1, this.secondArgumentEllipses2, secondPanelBounds, stateId, 150);
    }

    @Override
    public void mouseDoubleClicked(MouseEvent me) {
        super.mouseDoubleClicked(me);
        int stateId = -1;
        if (this.firstArgumentEllipses1.containsKey(me.getSource())) {
            stateId = this.firstArgumentEllipses1.get(me.getSource());
        } else if (this.secondArgumentEllipses1.containsKey(me.getSource())) {
            stateId = this.secondArgumentEllipses1.get(me.getSource());
        }
        Logger.assertProB((String)"stateId >= 0", (stateId >= 0 ? 1 : 0) != 0);
        CounterExample ce = ((CounterExampleFigure)this.getParent()).getModel();
        if (ce != null) {
            stateId += ce.getInitPath().size();
            History history = Animator.getAnimator().getHistory();
            try {
                CounterExampleHistoryHandler.showCounterExampleInAnimator();
                history.gotoPos(stateId);
            }
            catch (ExecutionException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
            catch (ProBException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        CounterExampleProposition firstArgument = ((CounterExampleBinaryOperator)this.model).getFirstArgument();
        List<CounterExampleProposition> firstChildren = firstArgument.getChildren();
        firstChildren = firstChildren.subList(1, firstChildren.size());
        this.setTrasparent(firstChildren);
        CounterExamplePropositionFigure firstArgumentFigure = this.getFigure(firstArgument);
        for (Connection connection : firstArgumentFigure.getConnections().values()) {
            connection.setVisible(false);
        }
        CounterExampleProposition secondArgument = ((CounterExampleBinaryOperator)this.model).getSecondArgument();
        List<CounterExampleProposition> secondChildren = secondArgument.getChildren();
        secondChildren = secondChildren.subList(1, secondChildren.size());
        this.setTrasparent(secondChildren);
        CounterExamplePropositionFigure secondArgumentFigure = this.getFigure(secondArgument);
        for (Connection connection : secondArgumentFigure.getConnections().values()) {
            connection.setVisible(false);
        }
        Object source = me.getSource();
        if (this.firstPanel == null || this.secondPanel == null) {
            return;
        }
        TitleBarBorder firstBorder = (TitleBarBorder)this.firstPanel.getBorder();
        TitleBarBorder secondBorder = (TitleBarBorder)this.secondPanel.getBorder();
        if (this.firstArgumentEllipses1.containsKey(source)) {
            secondBorder.setFont(this.normalFont);
            secondArgument.setVisible(false);
            int stateId = this.firstArgumentEllipses1.get(source);
            if (firstArgument.getStateId() == stateId) {
                boolean visible;
                boolean bl = visible = !firstArgument.isVisible();
                if (firstArgument.hasChildren()) {
                    firstBorder.setFont(visible ? this.boldFont : this.normalFont);
                }
                firstArgument.setVisible(visible);
            } else {
                if (firstArgument.hasChildren()) {
                    firstBorder.setFont(this.boldFont);
                }
                firstArgument.setStateId(stateId);
                firstArgument.setVisible(true);
            }
        } else {
            firstBorder.setFont(this.normalFont);
            firstArgument.setVisible(false);
            int stateId = this.secondArgumentEllipses1.get(source);
            if (secondArgument.getStateId() == stateId) {
                boolean visible;
                boolean bl = visible = !secondArgument.isVisible();
                if (secondArgument.hasChildren()) {
                    secondBorder.setFont(visible ? this.boldFont : this.normalFont);
                }
                secondArgument.setVisible(visible);
            } else {
                if (secondArgument.hasChildren()) {
                    secondBorder.setFont(this.boldFont);
                }
                secondArgument.setStateId(stateId);
                secondArgument.setVisible(true);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        int stateId;
        Ellipse source = (Ellipse)me.getSource();
        CounterExampleProposition argument = null;
        if (this.firstArgumentEllipses1.containsKey(source)) {
            argument = ((CounterExampleBinaryOperator)this.model).getFirstArgument();
            stateId = this.firstArgumentEllipses1.get(source);
        } else {
            argument = ((CounterExampleBinaryOperator)this.model).getSecondArgument();
            stateId = this.secondArgumentEllipses1.get(source);
        }
        if (!argument.hasChildren()) {
            return;
        }
        boolean painted = argument.isVisible();
        int argumentStateId = argument.getStateId();
        Label label = new Label();
        label.setForegroundColor(this.foregroundColor);
        String text = "open ";
        if (stateId == argumentStateId) {
            text = painted ? "close " : "open ";
        }
        label.setText("Click to " + text + String.valueOf(argument));
        source.setToolTip((IFigure)label);
    }
}

