/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.invcheck;

import de.prob.core.Animator;
import de.prob.core.ProBJobFinishedListener;
import de.prob.core.command.ConstraintBasedInvariantCheckCommand;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class InvariantCheckFinishedListener
extends ProBJobFinishedListener {
    private final Shell shell;

    public InvariantCheckFinishedListener(Shell shell) {
        this.shell = shell;
    }

    protected void showResult(IComposableCommand command, Animator animator) {
        String message;
        String dialogTitle;
        int dialogType;
        ConstraintBasedInvariantCheckCommand invCmd = (ConstraintBasedInvariantCheckCommand)command;
        ConstraintBasedInvariantCheckCommand.ResultType result = invCmd.getResult();
        switch (result) {
            case INTERRUPTED: {
                dialogType = 4;
                dialogTitle = "User Interrupt";
                message = "The invariant check has been interrupted by the user.";
                break;
            }
            case NO_VIOLATION_FOUND: {
                dialogType = 2;
                dialogTitle = "No Invariant Violation found";
                message = "No possible invariant violation has been found.";
                break;
            }
            case VIOLATION_FOUND: {
                dialogType = 1;
                dialogTitle = "Invariant Violation found";
                message = "An invariant violation has been found.\nThe first found example will be shown in the history.";
                this.displayViolation(invCmd, animator);
                break;
            }
            default: {
                Logger.notifyUser((String)("Unexpected result: " + String.valueOf(result)));
                return;
            }
        }
        if (this.shell.isDisposed()) {
            System.out.println("Invariant Check finished: " + dialogTitle);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)dialogType, (Shell)InvariantCheckFinishedListener.this.shell, (String)dialogTitle, (String)message, (int)0);
                }
            };
            this.shell.getDisplay().asyncExec(runnable);
        }
    }

    private void displayViolation(ConstraintBasedInvariantCheckCommand cmd, Animator animator) {
        ConstraintBasedInvariantCheckCommand.InvariantCheckCounterExample example = (ConstraintBasedInvariantCheckCommand.InvariantCheckCounterExample)cmd.getCounterExamples().iterator().next();
        Operation step1 = example.getStep1();
        Operation step2 = example.getStep2();
        try {
            animator.getHistory().gotoPos(0);
            ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)step1);
            ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)step2);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
    }
}

