/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.historyview;

import de.prob.ui.historyview.HistoryView;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class HistoryLabelProvider
extends CellLabelProvider {
    private final Color currentPositionColor = Display.getDefault().getSystemColor(29);
    final Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
    protected boolean showParameters = true;

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element != null && element instanceof HistoryView.HistViewItem) {
            HistoryView.HistViewItem item = (HistoryView.HistViewItem)element;
            cell.setText(this.getText(item));
            cell.setForeground(this.getForeground(item));
        }
    }

    protected Font getFont(HistoryView.HistViewItem item) {
        return item.followingStateIsSameAsCurrent() ? this.bold : null;
    }

    protected Color followingStateIsActive(HistoryView.HistViewItem item) {
        return item.followingStateIsActive() ? this.currentPositionColor : null;
    }

    protected String getText(HistoryView.HistViewItem item) {
        return null;
    }

    protected Color getForeground(HistoryView.HistViewItem item) {
        return null;
    }

    public void setShowParameters(boolean show) {
        this.showParameters = show;
    }
}

