/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.findvalidstate;

import de.prob.core.Animator;
import de.prob.core.ProBJobFinishedListener;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.FindValidStateCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FindValidStateFinishedListener
extends ProBJobFinishedListener {
    private final Shell shell;

    public FindValidStateFinishedListener(Shell shell) {
        this.shell = shell;
    }

    protected void showResult(IComposableCommand cmd, Animator animator) {
        String message;
        String dialogTitle;
        int dialogType;
        FindValidStateCommand command = (FindValidStateCommand)cmd;
        FindValidStateCommand.ResultType result = command.getResult();
        if (result == null) {
            dialogType = 1;
            dialogTitle = "Errow During Deadlock Freedom Check";
            message = "ProB did not return a result";
        } else {
            switch (result) {
                case NO_STATE_FOUND: {
                    dialogType = 4;
                    dialogTitle = "No State Found";
                    message = "No State satisfying both the Invariant and the Predicate was found.";
                    break;
                }
                case ERROR: {
                    dialogType = 1;
                    dialogTitle = "Errow During Search for Valid State";
                    message = "An unexpected error occurred while typechecking the given predicate.";
                    break;
                }
                case STATE_FOUND: {
                    dialogType = 2;
                    dialogTitle = "State found";
                    message = "The model contains a state satisfying the given predicate and the invariant, it will be shown in the state view.";
                    this.displayState(command, animator);
                    break;
                }
                case INTERRUPTED: {
                    dialogType = 4;
                    dialogTitle = "User Interrupt";
                    message = "The search has been interrupted by the user or a time-out.";
                    break;
                }
                default: {
                    Logger.notifyUser((String)("Unexpected result: " + String.valueOf(result)));
                    return;
                }
            }
        }
        if (this.shell.isDisposed()) {
            System.out.println("Deadlock freedom check finished: " + dialogTitle);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessageDialog.open((int)dialogType, (Shell)FindValidStateFinishedListener.this.shell, (String)dialogTitle, (String)message, (int)0);
                }
            };
            this.shell.getDisplay().asyncExec(runnable);
        }
    }

    private void displayState(FindValidStateCommand cmd, Animator animator) {
        Operation operation = cmd.getOperation();
        try {
            animator.getHistory().gotoPos(0);
            ExecuteOperationCommand.executeOperation((Animator)animator, (Operation)operation);
        }
        catch (ProBException e) {
            e.notifyUserOnce();
        }
    }
}

