/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.Animator;
import de.prob.core.LimitedLogger;
import de.prob.core.command.LoadEventBModelCommand;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.PerspectiveFactory;
import de.prob.ui.services.ContextLoadedProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.ISourceProviderService;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.RodinCore;

public class StartAnimationHandler
extends AbstractHandler
implements IHandler {
    private ISelection fSelection;
    private ModificationListener listener;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEventBRoot rootElement = this.getRootElement();
        IFile resource = this.extractResource(rootElement);
        ArrayList<String> errors = new ArrayList<String>();
        boolean realError = this.checkErrorMarkers(resource, errors);
        if (!errors.isEmpty()) {
            Animator.getAnimator().setRodinProjectHasErrorsOrWarnings();
            String message = "Some components in your project contain " + (realError ? "errors" : "warnings") + "!\n This can lead to unexpected behavior (e.g. missing variables) when animating with ProB.\nDetails:\n";
            StringBuffer stringBuffer = new StringBuffer(message);
            for (String string : errors) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            Logger.info((String)stringBuffer.toString());
            LimitedLogger.getLogger().log(stringBuffer.toString(), rootElement.getElementName(), null);
        } else {
            Animator.getAnimator().resetRodinProjectHasErrorsOrWarnings();
        }
        if (resource != null) {
            LimitedLogger.getLogger().log("user started animation", rootElement.getElementName(), null);
            this.registerModificationListener(resource);
            PerspectiveFactory.openPerspective();
            Animator animator = Animator.getAnimator();
            try {
                LoadEventBModelCommand.load((Animator)animator, (IEventBRoot)rootElement);
            }
            catch (ProBException e) {
                e.notifyUserOnce();
                throw new ExecutionException("Loading the machine failed", (Throwable)e);
            }
        }
        return null;
    }

    private boolean checkErrorMarkers(IFile resource, List<String> errors) {
        boolean result = false;
        IProject project = resource.getProject();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                errors.add(iMarker.getResource().getName() + ": " + iMarker.getAttribute("message", "unknown Error"));
                result = result || (Integer)iMarker.getAttribute("severity") == 2;
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    private IEventBRoot getRootElement() {
        IStructuredSelection ssel;
        IEventBRoot root = null;
        if (this.fSelection instanceof IStructuredSelection && (ssel = (IStructuredSelection)this.fSelection).size() == 1) {
            IRodinFile rodinFile;
            Object element = ssel.getFirstElement();
            if (element instanceof IEventBRoot) {
                root = (IEventBRoot)element;
            } else if (element instanceof IFile && (rodinFile = RodinCore.valueOf((IFile)((IFile)element))) != null) {
                root = (IEventBRoot)rodinFile.getRoot();
            }
        }
        return root;
    }

    private void updateContextLoadedProvider(boolean isContext) {
        ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        ContextLoadedProvider sourceProvider = (ContextLoadedProvider)service.getSourceProvider("de.prob.core.context_loaded");
        sourceProvider.setEnabled(isContext);
    }

    private IFile extractResource(IEventBRoot rootElement) {
        IFile resource = null;
        if (rootElement == null) {
            resource = null;
        } else if (rootElement instanceof IMachineRoot) {
            resource = ((IMachineRoot)rootElement).getSCMachineRoot().getResource();
            this.updateContextLoadedProvider(false);
        } else if (rootElement instanceof IContextRoot) {
            resource = ((IContextRoot)rootElement).getSCContextRoot().getResource();
            this.updateContextLoadedProvider(true);
        }
        return resource;
    }

    private void registerModificationListener(IFile resource) {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
        }
        this.listener = new ModificationListener(resource);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public static class ModificationListener
    implements IResourceChangeListener {
        private final IPath path;

        public ModificationListener(IFile resource) {
            this.path = resource == null ? null : resource.getProject().getFullPath();
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            IResourceDelta member;
            if (this.path != null && (member = (delta = event.getDelta()).findMember(this.path)) != null) {
                Animator.getAnimator().setDirty();
            }
        }
    }
}

