/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.Animator;
import de.prob.core.command.ModelCheckingCommand;
import de.prob.core.command.ModelCheckingResult;
import de.prob.core.command.ModelCheckingSearchOption;
import de.prob.core.command.SetPreferenceCommand;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ModelCheckingJob
extends Job {
    private final Animator animator = Animator.getAnimator();
    private boolean abort = false;
    private final List<String> options;
    private final String symmetryOption;
    private ModelCheckingResult<ModelCheckingCommand.Result> modelCheckingResult = null;
    private int workedSoFar = 0;

    public ModelCheckingJob(String name, Set<ModelCheckingSearchOption> options, String symmetryOption) {
        super(name);
        ArrayList<String> optlist = new ArrayList<String>();
        for (ModelCheckingSearchOption modelCheckingOption : options) {
            optlist.add(modelCheckingOption.name());
        }
        this.options = optlist;
        this.symmetryOption = symmetryOption;
    }

    public ModelCheckingCommand.Result getModelCheckingResult() {
        return (ModelCheckingCommand.Result)this.modelCheckingResult.getResult();
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.setSymmetry()) {
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask("Model Checking", 1000);
        while (!this.abort) {
            try {
                this.modelCheckingResult = this.doSomeModelchecking();
                this.options.remove("inspect_existing_nodes");
                monitor.setTaskName("Model Checking - States: " + this.modelCheckingResult.getNumStates() + " (processed " + this.modelCheckingResult.getProcessedTotal() + ") - Transitions: " + this.modelCheckingResult.getNumTransitions());
                int difference = this.modelCheckingResult.getWorked() - this.workedSoFar;
                if (difference > 0) {
                    monitor.worked(difference);
                    this.workedSoFar = this.modelCheckingResult.getWorked();
                }
            }
            catch (ProBException proBException) {
                return Status.CANCEL_STATUS;
            }
            boolean bl = this.abort = this.getModelCheckingResult().isAbort() || monitor.isCanceled();
        }
        return Status.OK_STATUS;
    }

    private boolean setSymmetry() {
        try {
            SetPreferenceCommand.setPreference((Animator)this.animator, (String)"SYMMETRY_MODE", (String)this.symmetryOption);
        }
        catch (ProBException proBException) {
            return false;
        }
        return true;
    }

    private ModelCheckingResult<ModelCheckingCommand.Result> doSomeModelchecking() throws ProBException {
        return ModelCheckingCommand.modelcheck((Animator)this.animator, (int)500, this.options);
    }
}

