/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.command.ModelCheckingSearchOption;
import de.prob.core.command.SymmetryReductionOption;
import de.prob.ui.DialogHelpers;
import de.prob.ui.eventb.ModelCheckingFinishedListener;
import de.prob.ui.eventb.ModelCheckingJob;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ModelCheckingDialog
extends Dialog {
    private Job job;
    private final Shell shell;
    private Button startButton;

    protected ModelCheckingDialog(Shell shell) {
        super(shell);
        this.shell = shell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 1;
        GridLayout glayout = new GridLayout(2, true);
        Composite c = new Composite(comp, 0);
        c.setLayout((Layout)glayout);
        Button[] checks = this.createSettingsGroup(c);
        Button[] symmetry = this.createSymmetryGroup(c);
        GridData data = new GridData(64);
        this.startButton = new Button(comp, 8);
        this.startButton.setText("Start Model Checking");
        this.startButton.setLayoutData((Object)data);
        this.startButton.addSelectionListener((SelectionListener)new StartButtonSelectionListener(checks, symmetry));
        return comp;
    }

    private Button[] createSymmetryGroup(Composite c) {
        Group group = DialogHelpers.createGroup(c, "Symmetry Reduction");
        SymmetryReductionOption[] symmetryOptions = SymmetryReductionOption.values();
        Button[] symmetry = new Button[symmetryOptions.length];
        int i = 0;
        while (i < symmetryOptions.length) {
            symmetry[i] = new Button((Composite)group, 16);
            symmetry[i].setText(symmetryOptions[i].getDescription());
            symmetry[i].setSelection(symmetryOptions[i].isSelectedOption());
            ++i;
        }
        return symmetry;
    }

    private Button[] createSettingsGroup(Composite c) {
        Group group = DialogHelpers.createGroup(c, "Settings");
        ModelCheckingSearchOption[] options = ModelCheckingSearchOption.values();
        Button[] checks = new Button[options.length];
        int i = 0;
        while (i < options.length) {
            checks[i] = new Button((Composite)group, 32);
            checks[i].setText(options[i].getDescription());
            checks[i].setSelection(options[i].isEnabledByDefault());
            ++i;
        }
        return checks;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Model Checking");
    }

    private final class StartButtonSelectionListener
    implements SelectionListener {
        private final Button[] checks;
        private final Button[] symmetry;

        private StartButtonSelectionListener(Button[] checks, Button[] symmetry) {
            this.checks = checks;
            this.symmetry = symmetry;
        }

        public void widgetSelected(SelectionEvent e) {
            String symmetryOption = this.selectSymmetryOption(this.symmetry);
            Set<ModelCheckingSearchOption> selectSettings = this.selectSettings(this.checks);
            this.scheduleJob(selectSettings, symmetryOption);
            ModelCheckingDialog.this.close();
        }

        private Set<ModelCheckingSearchOption> selectSettings(Button[] checks) {
            HashSet<ModelCheckingSearchOption> result = new HashSet<ModelCheckingSearchOption>();
            int i = 0;
            while (i < checks.length) {
                ModelCheckingSearchOption.get((int)i).setEnabledByDefault(checks[i].getSelection());
                if (checks[i].getSelection()) {
                    result.add(ModelCheckingSearchOption.get((int)i));
                }
                ++i;
            }
            return result;
        }

        private String selectSymmetryOption(Button[] symmetry) {
            int symmetryOption = 0;
            int i = 0;
            while (i < symmetry.length) {
                if (symmetry[i].getSelection()) {
                    symmetryOption = i;
                    break;
                }
                ++i;
            }
            SymmetryReductionOption.setSelectedOption((int)symmetryOption);
            return SymmetryReductionOption.get((int)symmetryOption).name();
        }

        private void scheduleJob(Set<ModelCheckingSearchOption> selectSettings, String symmetryOption) {
            ModelCheckingDialog.this.job = new ModelCheckingJob("Model Checking", selectSettings, symmetryOption);
            ModelCheckingDialog.this.job.setUser(true);
            ModelCheckingDialog.this.job.addJobChangeListener((IJobChangeListener)new ModelCheckingFinishedListener(ModelCheckingDialog.this.shell));
            ModelCheckingDialog.this.job.schedule();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

