/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.eventb;

import de.prob.core.Animator;
import de.prob.core.command.LoadEventBModelCommand;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.eventb.ProBAnimationPreferencePage;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eventb.core.IEventBRoot;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.RodinCore;

public class AnimationPreferencesDialog
extends PreferenceDialog {
    private Preferences configurationStorage;
    public static final String pluginId = "de.prob.ui";
    public static final String default_configuration_name = "General Configuration";
    public static final String preferencesName = "prob_configurations";
    public static final String okButtonText = "Animate";
    public static final String nodeTitleKey = "title";
    public static final String nodeTitleKeyError = "TitleNotFound";
    public static final String proBParentNodeId = "ProB Configurations";
    private static final String shellTitle = "Manage ProB Configurations";
    private static final String flushingErrorMessage = "Problem while storing configurations. ";
    private static final String loadConfigurationsError = "Problem while loading configurations. ";
    private static final String readingErrorMessage = "Problem while reading configuration. ";
    private IEventBRoot selectedEventBRoot;

    public AnimationPreferencesDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
        this.getPreferenceManager().removeAll();
        this.addProBParentNode();
    }

    public void updateButtons() {
        this.getButton(0).setEnabled(this.isCurrentPageValid());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(shellTitle);
    }

    public void updateTitle() {
        super.updateTitle();
        this.getTreeViewer().refresh();
    }

    public Preferences getSelectedConfiguration() {
        return this.getConfigurationStorage().node(this.getSelectedNodePreference());
    }

    protected Control createTreeAreaContents(Composite parent) {
        Composite treeAreaContentsDivider = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        treeAreaContentsDivider.setLayout((Layout)gl);
        treeAreaContentsDivider.setBackground(parent.getBackground());
        GridData gd = new GridData(1808);
        treeAreaContentsDivider.setLayoutData((Object)gd);
        ToolBar tb = new ToolBar(treeAreaContentsDivider, 16);
        tb.setLayoutData((Object)new GridData(256));
        ToolItem tiNew = new ToolItem(tb, 8);
        tiNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
        tiNew.setToolTipText("Create new configuration");
        tiNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnimationPreferencesDialog.this.addPreference("New Configuration", false);
            }
        });
        ToolItem tiDup = new ToolItem(tb, 8);
        tiDup.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        tiDup.setToolTipText("Duplicate selected configuration");
        tiDup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnimationPreferencesDialog.this.duplicatePreference();
            }
        });
        ToolItem tiDel = new ToolItem(tb, 8);
        tiDel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        tiDel.setToolTipText("Delete selected configuration");
        tiDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnimationPreferencesDialog.this.deletePreference();
            }
        });
        this.setTreeViewer(this.createTreeViewer(treeAreaContentsDivider));
        this.getTreeViewer().setInput((Object)this.getPreferenceManager());
        this.updateTreeFont(JFaceResources.getDialogFont());
        this.getTreeViewer().getControl().setLayoutData((Object)new GridData(1808));
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ProBLabelProvider());
        this.getTreeViewer().setComparator(new ViewerComparator());
        this.getTreeViewer().expandAll();
        this.layoutTreeAreaControl((Control)treeAreaContentsDivider);
        return treeAreaContentsDivider;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        super.getShell().getDefaultButton().setText(okButtonText);
    }

    protected Control createDialogArea(Composite parent) {
        Display display = this.getParentShell().getDisplay();
        Color bgColor = JFaceColors.getBannerBackground((Display)display);
        Composite newTitleArea = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.numColumns = 2;
        gl.marginLeft = 5;
        newTitleArea.setLayout((Layout)gl);
        newTitleArea.setLayoutData((Object)new GridData(768));
        newTitleArea.setBackground(bgColor);
        Label titleMessage = new Label(newTitleArea, 0);
        titleMessage.setText("Create, manage and run ProB configurations");
        titleMessage.setFont(JFaceResources.getBannerFont());
        titleMessage.setBackground(bgColor);
        Label titleImageLabel = new Label(newTitleArea, 0);
        titleImageLabel.setAlignment(131072);
        titleImageLabel.setBackground(bgColor);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)"icons/prob_animation_dialog.png");
        if (imageDescriptor != null) {
            titleImageLabel.setImage(imageDescriptor.createImage());
        }
        titleImageLabel.setLayoutData((Object)new GridData(768));
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        return super.createDialogArea(parent);
    }

    private void addPreference(String name, boolean duplicate) {
        String nodeTitle = this.getValidName(name);
        if (nodeTitle != null) {
            String uniqueId = UUID.randomUUID().toString();
            Preferences newPreferences = this.getConfigurationStorage().node(uniqueId);
            if (duplicate) {
                try {
                    String[] stringArray = this.getSelectedConfiguration().keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        newPreferences.put(s, this.getSelectedConfiguration().get(s, null));
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    this.notifyBackingStoreError(readingErrorMessage, (Exception)((Object)e));
                }
            } else if (this.selectedEventBRoot != null) {
                newPreferences.put("project", this.selectedEventBRoot.getEventBProject().toString());
                newPreferences.put("machine", this.selectedEventBRoot.getRodinFile().getElementName());
            }
            newPreferences.put(nodeTitleKey, nodeTitle);
            ProBAnimationPreferencePage preferencePage = new ProBAnimationPreferencePage(uniqueId, this.getConfigurationStorage());
            preferencePage.performOk();
            PreferenceNode node = new PreferenceNode(uniqueId, (IPreferencePage)preferencePage);
            this.getPreferenceManager().addTo(proBParentNodeId, (IPreferenceNode)node);
            this.getTreeViewer().refresh();
            this.setSelectedNodePreference(preferencePage.getConfigurationId());
            this.selectSavedItem();
        }
    }

    private void duplicatePreference() {
        if (this.getSelectedConfiguration() == null) {
            String name = default_configuration_name;
            this.addPreference(name, false);
        } else {
            String name = this.getSelectedConfiguration().get(nodeTitleKey, null);
            this.addPreference(name, true);
        }
    }

    private void deletePreference() {
        block15: {
            if (this.getSelectedPage() instanceof ProBAnimationPreferencePage) {
                ProBAnimationPreferencePage deletePage = (ProBAnimationPreferencePage)((Object)this.getSelectedPage());
                String deleteId = deletePage.getConfigurationId();
                try {
                    try {
                        this.getConfigurationStorage().node(deleteId).removeNode();
                    }
                    catch (BackingStoreException backingStoreException) {
                        this.saveConfigurations();
                        TreeItem selectedItem = this.getTreeViewer().getTree().getSelection()[0];
                        TreeItem parent = selectedItem.getParentItem();
                        int nextIndex = -1;
                        int currentIndex = parent.indexOf(selectedItem);
                        if (currentIndex < parent.getItemCount() - 1) {
                            nextIndex = currentIndex;
                        } else if (currentIndex > 0) {
                            nextIndex = currentIndex - 1;
                        }
                        this.getPreferenceManager().find(parent.getText()).remove(deleteId);
                        this.getTreeViewer().refresh();
                        if (parent.getItemCount() > 0) {
                            PreferenceNode nextNode = (PreferenceNode)parent.getItem(nextIndex).getData();
                            this.setSelectedNodePreference(nextNode.getId());
                            this.selectSavedItem();
                            break block15;
                        }
                        this.setSelectedNode(parent.getText());
                        this.selectSavedItem();
                    }
                }
                finally {
                    this.saveConfigurations();
                    TreeItem selectedItem = this.getTreeViewer().getTree().getSelection()[0];
                    TreeItem parent = selectedItem.getParentItem();
                    int nextIndex = -1;
                    int currentIndex = parent.indexOf(selectedItem);
                    if (currentIndex < parent.getItemCount() - 1) {
                        nextIndex = currentIndex;
                    } else if (currentIndex > 0) {
                        nextIndex = currentIndex - 1;
                    }
                    this.getPreferenceManager().find(parent.getText()).remove(deleteId);
                    this.getTreeViewer().refresh();
                    if (parent.getItemCount() > 0) {
                        PreferenceNode nextNode = (PreferenceNode)parent.getItem(nextIndex).getData();
                        this.setSelectedNodePreference(nextNode.getId());
                        this.selectSavedItem();
                    } else {
                        this.setSelectedNode(parent.getText());
                        this.selectSavedItem();
                    }
                }
            }
        }
    }

    private String getValidName(String name) {
        String bareName = name.replaceAll(" \\([0-9]+\\)", "");
        Object safeName = name;
        try {
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            String[] stringArray = this.getConfigurationStorage().childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String title = this.getConfigurationStorage().node(s).get(nodeTitleKey, null);
                if (title != null && title.replaceAll(" \\([0-9]+\\)", "").equals(bareName)) {
                    char ch = title.charAt(title.length() - 2);
                    if (Character.isDigit(ch)) {
                        numbers.add(Character.getNumericValue(ch));
                    } else {
                        numbers.add(0);
                    }
                }
                ++n2;
            }
            int count = 0;
            while (numbers.contains(count)) {
                ++count;
            }
            if (count > 0) {
                safeName = bareName + " (" + count + ")";
            }
        }
        catch (BackingStoreException e) {
            this.notifyBackingStoreError(readingErrorMessage, (Exception)((Object)e));
            return null;
        }
        return safeName;
    }

    public void setSelectedEventBRoot(IEventBRoot element) {
        this.selectedEventBRoot = element;
    }

    public void addProBParentNode() {
        InfoPage infoPage = new InfoPage();
        infoPage.setTitle(proBParentNodeId);
        PreferenceNode proBParentNode = new PreferenceNode(proBParentNodeId, (IPreferencePage)infoPage);
        this.getPreferenceManager().addToRoot((IPreferenceNode)proBParentNode);
    }

    public void loadConfigurations() {
        Preferences preferences = this.getConfigurationStorage();
        try {
            String[] stringArray = preferences.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                ProBAnimationPreferencePage preference = new ProBAnimationPreferencePage(nodeName, this.getConfigurationStorage());
                PreferenceNode node = new PreferenceNode(nodeName, (IPreferencePage)preference);
                this.getPreferenceManager().addTo(proBParentNodeId, (IPreferenceNode)node);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            this.notifyBackingStoreError(loadConfigurationsError, (Exception)((Object)e));
        }
    }

    public Preferences getConfigurationStorage() {
        if (this.configurationStorage == null) {
            this.configurationStorage = Platform.getPreferencesService().getRootNode().node("instance").node(preferencesName);
        }
        return this.configurationStorage;
    }

    public void saveConfigurations() {
        try {
            this.getConfigurationStorage().flush();
        }
        catch (BackingStoreException e) {
            this.notifyBackingStoreError(flushingErrorMessage, (Exception)((Object)e));
        }
    }

    public void notifyBackingStoreError(String m, Exception e) {
        String message = m + e.getLocalizedMessage();
        Logger.notifyUser((String)message, (Throwable)e);
    }

    public static void openAndAnimate(IEventBRoot currentSelection) {
        Shell shell = new Shell();
        AnimationPreferencesDialog dialog = new AnimationPreferencesDialog(shell, new PreferenceManager());
        dialog.loadConfigurations();
        if (currentSelection != null) {
            dialog.setSelectedEventBRoot(currentSelection);
        }
        if (dialog.open() == 0) {
            Preferences selConfig = dialog.getSelectedConfiguration();
            if (selConfig == null) {
                return;
            }
            String projectName = selConfig.get("project", "");
            String machineName = selConfig.get("machine", "");
            IInternalElement animateElement = null;
            if (!projectName.equals("") && ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists() && !machineName.equals("") && ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(machineName).exists()) {
                IFile animateFile = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(machineName);
                animateElement = RodinCore.valueOf((IFile)animateFile).getRoot();
            }
            if (animateElement == null) {
                MessageBox messageBox = new MessageBox(shell, 33);
                messageBox.setText("Error");
                messageBox.setMessage("Cannot animate machine: Project '" + projectName + "' or machine '" + machineName + "' do not exist.");
                messageBox.open();
                throw new UnsupportedOperationException("Cannot animate machine: Project '" + projectName + "' or machine '" + machineName + "' do not exist.");
            }
            Animator animator = Animator.getAnimator();
            animator.setCustomConfiguration(selConfig);
            try {
                LoadEventBModelCommand.load((Animator)animator, (IEventBRoot)((IEventBRoot)animateElement));
            }
            catch (ProBException proBException) {
                return;
            }
        }
    }

    private static class InfoPage
    extends PreferencePage {
        private InfoPage() {
        }

        protected Control createContents(Composite parent) {
            this.noDefaultAndApplyButton();
            Label lbInfo = new Label(parent, 0);
            lbInfo.setText("Configure animation settings from this dialog:");
            CLabel lbNew = new CLabel(parent, 0);
            lbNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
            lbNew.setText("- Press the 'New' button to create a new configuration.");
            CLabel lbDup = new CLabel(parent, 16384);
            lbDup.setText("- Press the 'Duplicate' button to copy the selected configuration.");
            lbDup.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
            CLabel lbDel = new CLabel(parent, 0);
            lbDel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            lbDel.setText("- Press the 'Delete' button to remove the selected configuration.");
            Label lbAdditionalInfo = new Label(parent, 0);
            lbAdditionalInfo.setText("There is also a general setting for animating machines under Preferences->ProB.");
            return parent;
        }

        public boolean isValid() {
            return true;
        }
    }

    private static class ProBLabelProvider
    extends PreferenceLabelProvider {
        private ProBLabelProvider() {
        }

        public Image getImage(Object element) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)AnimationPreferencesDialog.pluginId, (String)"icons/prob.png").createImage();
        }
    }
}

