/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui;

import de.prob.core.LimitedLogger;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

public class LimitedLogView
extends ViewPart
implements LimitedLogger.LogListener {
    private LimitedLogger logger;
    private TableViewer viewer;
    private Long offset;

    public void createPartControl(Composite parent) {
        this.logger = LimitedLogger.getLogger();
        this.logger.registerListener((LimitedLogger.LogListener)this);
        this.createViewer(parent);
        this.updateLoggingStart();
        this.viewer.setInput((Object)this.logger);
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new LogContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
    }

    private void createColumns(TableViewer viewer) {
        this.createColumn(viewer, 131072, "Time", 50);
        this.createColumn(viewer, 16384, "Category", 100);
        this.createColumn(viewer, 16384, "Description", 300);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.addDoubleClickListener((IDoubleClickListener)new LogViewerDoubleClick());
    }

    private void createColumn(TableViewer viewer, int style, String title, int width) {
        TableViewerColumn column = new TableViewerColumn(viewer, style);
        column.getColumn().setText(title);
        column.getColumn().setWidth(width);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
    }

    public void setFocus() {
        this.viewer.getTable().getParent().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.logger.unregisterListener((LimitedLogger.LogListener)this);
        this.logger = null;
    }

    public void newLoggingInfo() {
        if (this.viewer != null) {
            this.updateLoggingStart();
            this.asyncRefresh();
        }
    }

    private void updateLoggingStart() {
        if (this.offset == null) {
            this.offset = this.logger.getFirstLoggingTime();
        }
    }

    private void asyncRefresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LimitedLogView.this.viewer.refresh();
            }
        });
    }

    private static class LogContentProvider
    implements IStructuredContentProvider {
        private LogContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object != null && object instanceof LimitedLogger) {
                LimitedLogger logger = (LimitedLogger)object;
                return logger.getEntries();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }
    }

    private class LogLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LogLabelProvider() {
        }

        public Image getColumnImage(Object object, int column) {
            return null;
        }

        public String getColumnText(Object object, int column) {
            String result;
            if (object != null && object instanceof LimitedLogger.LogEntry) {
                LimitedLogger.LogEntry entry = (LimitedLogger.LogEntry)object;
                switch (column) {
                    case 0: {
                        long time = entry.getTime() - (LimitedLogView.this.offset == null ? 0L : LimitedLogView.this.offset);
                        result = String.format("%,d", time);
                        break;
                    }
                    case 1: {
                        result = entry.getCategory();
                        break;
                    }
                    case 2: {
                        result = entry.getShortDescription();
                        break;
                    }
                    default: {
                        result = null;
                        break;
                    }
                }
            } else {
                result = null;
            }
            return result;
        }
    }

    private class LogViewerDoubleClick
    implements IDoubleClickListener {
        private LogViewerDoubleClick() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection != null && !selection.isEmpty()) {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                LimitedLogger.LogEntry entry = (LimitedLogger.LogEntry)ssel.getFirstElement();
                LimitedLogView.this.offset = entry.getTime();
                LimitedLogView.this.asyncRefresh();
            }
        }
    }
}

