/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview.statetree;

import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.State;
import de.prob.ui.stateview.statetree.AbstractStateTreeElement;
import de.prob.ui.stateview.statetree.EStateTreeElementProperty;
import de.prob.ui.stateview.statetree.StateDependendElement;
import de.prob.ui.stateview.statetree.StateTreeElement;
import de.prob.ui.stateview.statetree.StateTreeVariable;
import de.prob.ui.stateview.statetree.StaticStateElement;
import java.util.ArrayList;
import java.util.List;

public class StateTreeSection
extends AbstractStateTreeElement {
    private final String section;
    private final List<StateTreeElement> children;
    private final boolean isMainSectionOfVariable;

    public StateTreeSection(String section, MachineDescription md) {
        super(null);
        this.section = section;
        List varnames = md.getIdentifiersOfSection(section);
        ArrayList<StateTreeElement> children = new ArrayList<StateTreeElement>();
        boolean isMainSectionOfVariable = false;
        for (String varname : varnames) {
            String mainSection = md.getSectionOfIdentifier(varname);
            boolean isInMainSection = section.equals(mainSection);
            children.add(new StateTreeVariable(this, varname, isInMainSection));
            isMainSectionOfVariable |= isInMainSection;
        }
        this.children = children;
        this.isMainSectionOfVariable = isMainSectionOfVariable;
    }

    @Override
    public StaticStateElement[] getChildren() {
        return this.children.toArray(StateTreeVariable.EMPTY_ARRAY);
    }

    @Override
    public String getLabel() {
        return this.section;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isMainSectionOfVariable() {
        return this.isMainSectionOfVariable;
    }

    @Override
    public boolean hasChanged(State current, State last) {
        for (StateTreeElement child : this.children) {
            if (!child.hasChanged(current, last)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StateDependendElement getValue(State state) {
        return new StateDependendElement(state, null, this.hasChildren() ? EStateTreeElementProperty.NONBOOLEAN : EStateTreeElementProperty.INACTIVE);
    }
}

