/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.ui.stateview.StateViewPart;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public class ToggleShowDuplicatesHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    private static final String COMMAND_ID = "de.prob.ui.stateview.toggleShowDuplicates";
    private static final String STATE_ID = "de.prob.ui.stateview.duplicateFilterState";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        State state = event.getCommand().getState(STATE_ID);
        if (state == null) {
            throw new ExecutionException("Command state de.prob.ui.stateview.duplicateFilterState not found");
        }
        boolean newFilterValue = this.toggleState(state);
        this.setFilter(newFilterValue);
        return null;
    }

    private void setFilter(boolean newFilterValue) throws ExecutionException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        StateViewPart view = (StateViewPart)page.findView("de.prob.ui.StateView");
        if (view == null) {
            throw new ExecutionException("View de.prob.ui.StateView not found");
        }
        view.setDuplicateVariableFilter(newFilterValue);
    }

    private boolean toggleState(State state) {
        Boolean filterSet = (Boolean)state.getValue();
        state.setValue((Object)(filterSet == false ? 1 : 0));
        return filterSet == false;
    }

    public void updateElement(UIElement element, Map parameters) {
        State state = ToggleShowDuplicatesHandler.getCurrentState(element.getServiceLocator());
        Boolean filterSet = (Boolean)state.getValue();
        element.setChecked(filterSet.booleanValue());
    }

    public static State getCurrentState(IServiceLocator locator) {
        ICommandService service = (ICommandService)locator.getService(ICommandService.class);
        Command command = service.getCommand(COMMAND_ID);
        State state = command.getState(STATE_ID);
        return state;
    }
}

