/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ShownState {
    public static final String OTHER_SECTION_ID = "__Other__";
    private State current;
    private State last;
    private MachineDescription description;
    private Collection<String> usedSections;
    private List<String> otherVariables;

    private void reset() {
        this.usedSections = null;
        this.otherVariables = null;
    }

    private void compute() {
        if (this.usedSections == null) {
            this.usedSections = new HashSet<String>();
            this.addUsedSections(this.current);
            this.addUsedSections(this.last);
        }
    }

    public void setMachineDescription(MachineDescription description) {
        this.reset();
        this.description = description;
    }

    public void setCurrent(State current) {
        this.reset();
        this.current = current;
    }

    public void setLast(State last) {
        this.reset();
        this.last = last;
    }

    public MachineDescription getMachineDescription() {
        return this.description;
    }

    public List<String> getSections() {
        List<String> allSectionNames;
        List<String> sectionNames;
        this.compute();
        if (this.description == null) {
            sectionNames = Collections.emptyList();
        } else {
            List neSecs = this.description.getNonEmptySections();
            sectionNames = new ArrayList<String>(neSecs.size());
            for (MachineDescription.Section s : neSecs) {
                sectionNames.add(s.getName());
            }
        }
        if (this.isOtherSectionNeeded()) {
            allSectionNames = new ArrayList(sectionNames);
            allSectionNames.add(OTHER_SECTION_ID);
        } else {
            allSectionNames = sectionNames;
        }
        return allSectionNames;
    }

    public boolean sectionHasValue(String section) {
        this.compute();
        return this.usedSections.contains(section);
    }

    public List<String> getSectionVariables(String section) {
        List<Object> result;
        this.compute();
        if (OTHER_SECTION_ID.equals(section) && this.isOtherSectionNeeded()) {
            result = this.otherVariables;
        } else {
            List<Object> vars = this.description == null ? Collections.emptyList() : this.description.getIdentifiersOfSection(section);
            result = vars == null ? Collections.emptyList() : vars;
        }
        return result;
    }

    private boolean isOtherSectionNeeded() {
        return this.sectionHasValue(OTHER_SECTION_ID);
    }

    private void addUsedSections(State state) {
        if (state != null) {
            for (String id : state.getValues().keySet()) {
                String section;
                String string = section = this.description == null ? null : this.description.getSectionOfIdentifier(id);
                if (section != null) {
                    this.usedSections.add(section);
                    this.usedSections.addAll(this.description.getAllSectionsOfIdentifier(id));
                } else {
                    this.usedSections.add(OTHER_SECTION_ID);
                    if (this.otherVariables == null) {
                        this.otherVariables = new ArrayList<String>();
                    }
                    if (!this.otherVariables.contains(id)) {
                        this.otherVariables.add(id);
                    }
                }
                this.usedSections.add(section == null ? OTHER_SECTION_ID : section);
            }
        }
    }
}

