/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.stateview;

import de.prob.ui.stateview.IVisibilityProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class LabelViewer
extends ContentViewer {
    private final Label label;
    private Object content;
    private ISelection selection;

    public LabelViewer(Composite parent, int style) {
        this.label = new Label(parent, style);
        this.label.setText("");
    }

    public LabelViewer(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public Control getControl() {
        return this.label;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void addMouseListener(MouseListener listener) {
        this.label.addMouseListener(listener);
    }

    public void refresh() {
        IBaseLabelProvider provider = this.getLabelProvider();
        if (provider instanceof ILabelProvider) {
            ILabelProvider labelprovider = (ILabelProvider)provider;
            String text = labelprovider.getText(this.content);
            this.label.setText(text == null ? "" : text);
        }
        if (provider instanceof IFontProvider) {
            IFontProvider fontprovider = (IFontProvider)provider;
            this.label.setFont(fontprovider.getFont(this.content));
        }
        if (provider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)provider;
            this.label.setBackground(colorProvider.getBackground(this.content));
            this.label.setForeground(colorProvider.getForeground(this.content));
        }
        if (provider instanceof IVisibilityProvider) {
            IVisibilityProvider visibilityProvider = (IVisibilityProvider)provider;
            this.label.setVisible(visibilityProvider.isVisible(this.content));
        }
        this.label.update();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection = selection;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.content = ((ISimpleContentProvider)this.getContentProvider()).convert(input);
        this.refresh();
    }

    public static interface ISimpleContentProvider
    extends IContentProvider {
        public Object convert(Object var1);
    }
}

