/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.services;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class HistoryActiveProvider
extends AbstractSourceProvider {
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String FORWARD_SERVICE = "de.prob.core.history.forward_service";
    public static final String BACKWARD_SERVICE = "de.prob.core.history.backward_service";
    private boolean forward = false;
    private boolean backward = false;

    public Map<String, String> getCurrentState() {
        HashMap<String, String> state = new HashMap<String, String>(2);
        this.addToState(state, this.backward, BACKWARD_SERVICE);
        this.addToState(state, this.forward, FORWARD_SERVICE);
        return state;
    }

    private void addToState(Map<String, String> state, boolean flag, String service) {
        String f = flag ? ENABLED : DISABLED;
        state.put(service, f);
    }

    public String[] getProvidedSourceNames() {
        return new String[]{FORWARD_SERVICE, BACKWARD_SERVICE};
    }

    public boolean isBackwardEnabled() {
        return this.backward;
    }

    public boolean isForwardEnabled() {
        return this.forward;
    }

    public void historyChange() {
        History history = Animator.getAnimator().getHistory();
        int current = history.getCurrentPosition();
        boolean notEmpty = !history.isEmpty();
        boolean notFirst = current != 0;
        boolean notLast = current != history.size() - 1;
        this.backward = notEmpty && notFirst;
        this.forward = notEmpty && notLast;
        this.fireSourceChanged(0, this.getCurrentState());
    }

    public void dispose() {
    }
}

