/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.ui.StateBasedViewPart;
import de.prob.ui.operationview.FilterListener;
import de.prob.ui.operationview.OperationTableViewer;
import de.prob.ui.services.ModelLoadedProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.services.ISourceProviderService;

public class OperationViewPart
extends StateBasedViewPart
implements FilterListener {
    private Composite pageComposite;

    @Override
    public Control createStatePartControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new FillLayout());
        OperationTableViewer.create(this.pageComposite, 68356);
        this.hookContextMenu();
        this.updateModelLoadedProvider();
        return this.pageComposite;
    }

    @Override
    protected void stateChanged(State activeState, Operation operation) {
        OperationTableViewer.getInstance().getViewer().setInput((Object)activeState);
        OperationTableViewer.getInstance().refresh();
    }

    private void hookContextMenu() {
        final OperationViewPart x = this;
        TableViewer viewer = OperationTableViewer.getInstance().getViewer();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                x.fillContextMenu(manager);
            }
        });
        Control c = viewer.getControl();
        Menu menu = menuMgr.createContextMenu(c);
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected void stateReset() {
        OperationTableViewer.destroy();
    }

    @Override
    public void filtersChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OperationTableViewer.getInstance().refresh();
            }
        });
    }

    private void updateModelLoadedProvider() {
        ISourceProviderService service = (ISourceProviderService)this.getSite().getService(ISourceProviderService.class);
        ModelLoadedProvider sourceProvider = (ModelLoadedProvider)service.getSourceProvider("de.prob.core.model_loaded");
        sourceProvider.setEnabled(true);
    }
}

