/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.ui.operationview.Filter;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilterDialog
extends Dialog
implements SelectionListener {
    final Shell dialog;
    private Button buttonNew;
    private Button buttonRemove;
    private Button buttonSelectAll;
    private Button buttonDeselectAll;
    private Table table;
    private Button buttonDone;
    private List<Filter> filters = new LinkedList<Filter>();
    private static final String TABLE_INFO = "User patterns to exclude from the view:";

    public FilterDialog(Shell parent, List<Filter> filters) {
        super(parent);
        this.dialog = new Shell(parent, 67696);
        this.dialog.setText("Filters");
        this.createControls();
        this.setFilters(filters);
    }

    public FilterDialog(Shell parent, int style, List<Filter> filters) {
        super(parent, style);
        this.dialog = new Shell(parent, style);
        this.dialog.setText("Filters");
        this.createControls();
        this.setFilters(filters);
    }

    private void setFilters(List<Filter> filters) {
        if (filters == null) {
            return;
        }
        this.filters.addAll(filters);
        for (Filter filter : filters) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(filter.getName());
            tableItem.setChecked(filter.getEnabled().booleanValue());
            tableItem.setData((Object)filter);
        }
    }

    private void createControls() {
        this.dialog.setLayout((Layout)new RowLayout());
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 15;
        formLayout.marginWidth = 10;
        this.dialog.setLayout((Layout)formLayout);
        Label label1 = new Label((Composite)this.dialog, 0);
        label1.setText(TABLE_INFO);
        FormData formaData = new FormData();
        label1.setLayoutData((Object)formaData);
        this.table = new Table((Composite)this.dialog, 2080);
        formaData = new FormData();
        formaData.left = new FormAttachment(0, 0);
        formaData.top = new FormAttachment((Control)label1, -5);
        formaData.right = new FormAttachment(75, 0);
        formaData.bottom = new FormAttachment(90, 0);
        this.table.setLayoutData((Object)formaData);
        this.buttonNew = new Button((Composite)this.dialog, 8);
        this.buttonNew.setText("&New");
        this.buttonNew.addSelectionListener((SelectionListener)this);
        formaData = new FormData();
        formaData.top = new FormAttachment((Control)label1, 0);
        formaData.left = new FormAttachment((Control)this.table, 0);
        formaData.right = new FormAttachment(100, 0);
        this.buttonNew.setLayoutData((Object)formaData);
        this.buttonRemove = new Button((Composite)this.dialog, 8);
        this.buttonRemove.setText("&Remove");
        this.buttonRemove.addSelectionListener((SelectionListener)this);
        formaData = new FormData();
        formaData.top = new FormAttachment((Control)this.buttonNew, 0);
        formaData.left = new FormAttachment((Control)this.table, 0);
        formaData.right = new FormAttachment(100, 0);
        this.buttonRemove.setLayoutData((Object)formaData);
        this.buttonSelectAll = new Button((Composite)this.dialog, 8);
        this.buttonSelectAll.setText("Select &All");
        this.buttonSelectAll.addSelectionListener((SelectionListener)this);
        formaData = new FormData();
        formaData.top = new FormAttachment((Control)this.table);
        this.buttonSelectAll.setLayoutData((Object)formaData);
        this.buttonDeselectAll = new Button((Composite)this.dialog, 8);
        this.buttonDeselectAll.setText("&Deselect All");
        this.buttonDeselectAll.addSelectionListener((SelectionListener)this);
        formaData = new FormData();
        formaData.top = new FormAttachment((Control)this.table, 0);
        formaData.left = new FormAttachment((Control)this.buttonSelectAll);
        this.buttonDeselectAll.setLayoutData((Object)formaData);
        this.buttonDone = new Button((Composite)this.dialog, 8);
        this.buttonDone.setText("    &Ok    ");
        this.buttonDone.addSelectionListener((SelectionListener)this);
        formaData = new FormData();
        formaData.top = new FormAttachment((Control)this.table, 0);
        formaData.right = new FormAttachment(100, 0);
        this.buttonDone.setLayoutData((Object)formaData);
        this.dialog.pack();
    }

    public List<Filter> open() {
        this.dialog.open();
        Display display = this.dialog.getDisplay();
        while (!this.dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.filters;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.buttonNew) {
            FilterInputDialog filterDialog = new FilterInputDialog(this.dialog);
            Filter newFilter = filterDialog.open();
            if (newFilter != null) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(newFilter.getName());
                tableItem.setChecked(true);
                tableItem.setData((Object)newFilter);
            }
        } else if (e.getSource() == this.buttonRemove) {
            if (this.table.getSelectionCount() > 0) {
                this.table.getSelection()[0].dispose();
            }
        } else if (e.getSource() == this.buttonSelectAll) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.table.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(true);
                ++n2;
            }
        } else if (e.getSource() == this.buttonDeselectAll) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.table.getItems();
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                item.setChecked(false);
                ++n3;
            }
        } else if (e.getSource() == this.buttonDone) {
            TableItem[] items = this.table.getItems();
            this.filters = new LinkedList<Filter>();
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n4 = 0;
            while (n4 < n) {
                TableItem item = tableItemArray[n4];
                Assert.isTrue((boolean)(item.getData() instanceof Filter));
                this.filters.add((Filter)item.getData());
                ++n4;
            }
            this.dialog.dispose();
        }
    }

    private static final class FilterInputDialog
    extends Dialog {
        private String pattern;
        private String name;
        private Text textName;
        private Text textPattern;
        private Button buttonOk;

        public FilterInputDialog(Shell parent) {
            super(parent, 67680);
        }

        public Filter open() {
            Shell parent = this.getParent();
            Shell shell = new Shell(parent, 67680);
            shell.setText(this.getText());
            this.createControls(shell);
            shell.pack();
            shell.open();
            Display display = parent.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (this.pattern == null) {
                return null;
            }
            if (this.name == null || this.name.length() == 0) {
                this.name = this.pattern;
            }
            return new Filter(this.pattern, this.name, true);
        }

        private void createControls(final Shell shell) {
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 15;
            formLayout.marginWidth = 10;
            formLayout.spacing = 5;
            shell.setLayout((Layout)formLayout);
            Label labelPattern = new Label((Composite)shell, 0);
            labelPattern.setText("Pattern to exclude from the view:\n(Pattern is case sensitive. *=any string, ?=any character.)");
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            labelPattern.setLayoutData((Object)formData);
            this.textPattern = new Text((Composite)shell, 2048);
            formData = new FormData();
            formData.width = 300;
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)labelPattern);
            this.textPattern.setLayoutData((Object)formData);
            Label labelName = new Label((Composite)shell, 0);
            labelName.setText("Name (optional):");
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.top = new FormAttachment((Control)this.textPattern);
            labelName.setLayoutData((Object)formData);
            this.textName = new Text((Composite)shell, 2048);
            formData = new FormData();
            formData.width = 300;
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)labelName);
            this.textName.setLayoutData((Object)formData);
            Button buttonCancel = new Button((Composite)shell, 2048);
            buttonCancel.setText("&Cancel");
            formData = new FormData();
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.textName);
            buttonCancel.setLayoutData((Object)formData);
            this.buttonOk = new Button((Composite)shell, 2048);
            this.buttonOk.setText("    &Ok    ");
            formData = new FormData();
            formData.right = new FormAttachment((Control)buttonCancel, 0);
            formData.top = new FormAttachment((Control)this.textName);
            this.buttonOk.setLayoutData((Object)formData);
            this.buttonOk.setEnabled(false);
            buttonCancel.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    pattern = null;
                    shell.dispose();
                }
            });
            this.buttonOk.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    name = textName.getText();
                    shell.dispose();
                }
            });
            this.textPattern.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    if (textPattern.getText().length() == 0) {
                        pattern = null;
                        buttonOk.setEnabled(false);
                    } else {
                        name = textName.getText();
                        pattern = textPattern.getText();
                        buttonOk.setEnabled(true);
                    }
                }
            });
            shell.setDefaultButton(this.buttonOk);
        }
    }
}

