/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.operationview;

import de.prob.core.Animator;
import de.prob.core.command.ExecuteRandomStepsCommand;
import de.prob.exceptions.ProBException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExecuteRandomHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        int steps = -1;
        try {
            steps = Integer.parseInt(event.getParameter("de.prob.ui.randomoperation.steps"));
        }
        catch (NumberFormatException numberFormatException) {}
        if (steps < 0) {
            try {
                steps = this.askForValue(shell);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        this.animate(steps);
        return null;
    }

    public void animate(int steps) {
        try {
            Animator animator = Animator.getAnimator();
            ExecuteRandomStepsCommand.executeOperation((Animator)animator, (int)steps);
        }
        catch (ProBException proBException) {
            return;
        }
    }

    private int askForValue(Shell shell) {
        InputDialog inputDialog = new InputDialog(shell, "Random Animation", "Number of steps:", "1", new IInputValidator(){
            String errormsg = "Number must be a non-negative Integer.";

            public String isValid(String newText) {
                Integer num;
                try {
                    num = Integer.parseInt(newText);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.errormsg;
                }
                if (num < 0) {
                    return this.errormsg;
                }
                return null;
            }
        });
        inputDialog.open();
        String answer = inputDialog.getValue();
        if (answer != null) {
            return Integer.parseInt(answer);
        }
        throw new NumberFormatException();
    }
}

