/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.logging.Logger;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.ui.ltl.CounterExampleViewPart;
import de.prob.ui.ltl.LtlCheckingJob;
import de.prob.ui.ltl.LtlStrings;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class LtlCheckingFinishedListener
extends JobChangeAdapter {
    protected final Shell shell;

    public LtlCheckingFinishedListener(Shell shell) {
        this.shell = shell;
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job instanceof LtlCheckingJob) {
            LtlCheckingJob ltlJob = (LtlCheckingJob)job;
            if (!ltlJob.isAnErrorOccurred()) {
                this.showResult(ltlJob.getModelCheckingResult());
            }
        } else {
            Logger.notifyUser((String)("The job has a wrong type. Expected LtlCheckingJob but got " + String.valueOf(job.getClass())));
        }
    }

    protected void showCounterexampleInView(LtlCheckingCommand.Result modelCheckingResult) {
        CounterExample counterExample = new CounterExample(modelCheckingResult);
        CounterExampleViewPart counterExampleView = CounterExampleViewPart.showDefault();
        counterExampleView.addCounterExample(counterExample);
    }

    private void showResult(final LtlCheckingCommand.Result modelCheckingResult) {
        int displayType;
        String message;
        String title;
        Logger.assertProB((String)"modelCheckingResult != null", (modelCheckingResult != null ? 1 : 0) != 0);
        switch (modelCheckingResult.getStatus()) {
            case incomplete: {
                title = LtlStrings.ltlResultIncompleteTitle;
                message = LtlStrings.ltlResultIncompleteTitle;
                displayType = 4;
                break;
            }
            case ok: {
                title = LtlStrings.ltlResultOkTitle;
                message = LtlStrings.ltlResultOkMessage;
                displayType = 2;
                break;
            }
            case counterexample: {
                title = LtlStrings.ltlResultCounterexampleTitle;
                message = LtlStrings.ltlResultCounterexampleMessage;
                displayType = 1;
                break;
            }
            case nostart: {
                title = LtlStrings.ltlResultNoStartTitle;
                message = LtlStrings.ltlResultNoStartMessage;
                displayType = 4;
                break;
            }
            case typeerror: {
                Logger.notifyUser((String)"Internal error: Type-Checking the LTL formula failed");
                return;
            }
            default: {
                Logger.notifyUser((String)("Uncovered case in LTL Result Type: " + String.valueOf(modelCheckingResult)));
                return;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)displayType, (Shell)LtlCheckingFinishedListener.this.shell, (String)title, (String)message, (int)0);
                ListPrologTerm counterExample = modelCheckingResult.getCounterexample();
                if (counterExample != null) {
                    LtlCheckingFinishedListener.this.showCounterexampleInView(modelCheckingResult);
                }
            }
        };
        this.shell.getDisplay().asyncExec(runnable);
    }
}

