/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleFigure;
import de.prob.ui.ltl.CounterExamplePropositionFigure;
import de.prob.ui.ltl.handler.CounterExampleHistoryHandler;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public final class CounterExampleUnaryFigure
extends CounterExamplePropositionFigure
implements MouseMotionListener {
    private Panel panel;
    protected final Hashtable<Ellipse, Integer> argumentEllipses1 = new Hashtable();
    protected final Hashtable<Integer, Ellipse> argumentEllipses2 = new Hashtable();

    public CounterExampleUnaryFigure(CounterExampleProposition model) {
        super(model);
        this.bounds = new Rectangle(50, 50, 50 * (model.getValues().size() * 2 + 1), 125);
    }

    @Override
    protected void drawProposition(CounterExamplePropositionFigure parent) {
        CounterExampleFigure counterExampleFigure = (CounterExampleFigure)this.getParent();
        Insets insets = this.getInsets();
        if (parent != null) {
            Rectangle parentBounds = parent.getBounds();
            this.bounds.x = parentBounds.x - insets.left;
            this.bounds.y = parentBounds.y + parentBounds.height + 25;
        } else {
            List<RectangleFigure> states = counterExampleFigure.getStates();
            int i = 0;
            while (i < states.size()) {
                RectangleFigure state = states.get(i);
                if (!counterExampleFigure.getChildren().contains(state)) {
                    state.setBounds(new Rectangle(100 * (i + 1) + insets.left, 50, 50, 50 + 6 * insets.top));
                    counterExampleFigure.add((IFigure)state, 0);
                }
                ++i;
            }
        }
        counterExampleFigure.setConstraint((IFigure)this, new Rectangle(this.bounds));
        this.removeAll();
        int stateId = this.model.getStateId();
        CounterExampleProposition argument = ((CounterExampleUnaryOperator)this.model).getArgument();
        List positions = (List)((CounterExampleUnaryOperator)this.model).getHighlightedPositions().get(stateId);
        Rectangle panelBounds = new Rectangle(this.bounds.x + 20, this.bounds.y + 20, this.bounds.width, this.bounds.height);
        this.panel = this.drawPropositionFigure(parent, this.bounds, argument, positions, this.argumentEllipses1, this.argumentEllipses2, panelBounds, stateId, 50);
    }

    @Override
    public void mouseDoubleClicked(MouseEvent me) {
        super.mouseDoubleClicked(me);
        int stateId = this.argumentEllipses1.get(me.getSource());
        Logger.assertProB((String)"stateId >= 0", (stateId >= 0 ? 1 : 0) != 0);
        CounterExample ce = ((CounterExampleFigure)this.getParent()).getModel();
        if (ce != null) {
            stateId += ce.getInitPath().size();
            Animator animator = Animator.getAnimator();
            History history = animator.getHistory();
            try {
                CounterExampleHistoryHandler.showCounterExampleInAnimator();
                history.gotoPos(stateId);
            }
            catch (ExecutionException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
            catch (ProBException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.button != 1) {
            return;
        }
        super.mousePressed(me);
        int stateId = this.argumentEllipses1.get(me.getSource());
        CounterExampleProposition argument = ((CounterExampleUnaryOperator)this.model).getArgument();
        List<CounterExampleProposition> children = argument.getChildren();
        children = children.subList(1, children.size());
        this.setTrasparent(children);
        CounterExamplePropositionFigure argumentFigure = this.getFigure(argument);
        for (Connection connection : argumentFigure.getConnections().values()) {
            connection.setVisible(false);
        }
        TitleBarBorder border = (TitleBarBorder)this.panel.getBorder();
        if (argument.getStateId() == stateId) {
            boolean visible;
            boolean bl = visible = !argument.isVisible();
            if (argument.hasChildren()) {
                border.setFont(visible ? this.boldFont : this.normalFont);
            }
            argument.setVisible(visible);
        } else {
            if (argument.hasChildren()) {
                border.setFont(this.boldFont);
            }
            argument.setStateId(stateId);
            argument.setVisible(true);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        Ellipse source = (Ellipse)me.getSource();
        CounterExampleProposition argument = ((CounterExampleUnaryOperator)this.model).getArgument();
        if (!argument.hasChildren()) {
            return;
        }
        boolean painted = argument.isVisible();
        int argumentStateId = argument.getStateId();
        int stateId = this.argumentEllipses1.get(source);
        Label label = new Label();
        label.setForegroundColor(this.foregroundColor);
        String text = "open ";
        if (stateId == argumentStateId) {
            text = painted ? "close " : "open ";
        }
        label.setText("Click to " + text + String.valueOf(argument));
        source.setToolTip((IFigure)label);
    }
}

