/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.ui.ltl.CounterExampleTreeViewer;
import java.util.List;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;

public final class CounterExampleTreeMouseMoveAdapter
implements MouseMoveListener {
    private final CounterExampleTreeViewer treeViewer;
    private ViewerCell currentCell;

    public CounterExampleTreeMouseMoveAdapter(CounterExampleTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void mouseMove(MouseEvent e) {
        ViewerCell cell = this.treeViewer.getCell(new Point(e.x, e.y));
        if (cell != null && !cell.equals((Object)this.currentCell)) {
            this.currentCell = cell;
            CounterExampleProposition element = (CounterExampleProposition)cell.getElement();
            LtlCheckingCommand.PathType pathType = element.getPathType();
            int loopEntry = element.getLoopEntry();
            String toolTip = "PathType: " + String.valueOf(pathType) + ", loopEntry = " + loopEntry;
            int columnIndex = cell.getColumnIndex();
            if (cell.getColumnIndex() > 0) {
                CounterExampleBinaryOperator binary;
                List firstAllPositions;
                if (element instanceof CounterExampleUnaryOperator) {
                    CounterExampleUnaryOperator unary = (CounterExampleUnaryOperator)element;
                    List allPositions = unary.getHighlightedPositions();
                    if (columnIndex - 1 < allPositions.size()) {
                        List positions = (List)allPositions.get(columnIndex - 1);
                        toolTip = toolTip + ". Positions: " + String.valueOf(positions);
                    }
                } else if (element instanceof CounterExampleBinaryOperator && columnIndex - 1 < (firstAllPositions = (binary = (CounterExampleBinaryOperator)element).getFirstHighlightedPositions()).size()) {
                    List firstPositions = (List)binary.getFirstHighlightedPositions().get(columnIndex - 1);
                    List secondPositions = (List)binary.getSecondHighlightedPositions().get(columnIndex - 1);
                    toolTip = toolTip + ". FirstPositions: " + String.valueOf(firstPositions);
                    toolTip = toolTip + ", SecondPositions: " + String.valueOf(secondPositions);
                }
            }
            cell.getControl().setToolTipText(toolTip);
            System.out.println(element);
        }
    }
}

