/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleTreeViewer;
import de.prob.ui.ltl.handler.CounterExampleHistoryHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public final class CounterExampleTreeMouseAdapter
extends MouseAdapter {
    private final CounterExampleTreeViewer treeViewer;
    private final CounterExample counterExample;

    public CounterExampleTreeMouseAdapter(CounterExampleTreeViewer treeViewer, CounterExample counterExample) {
        this.treeViewer = treeViewer;
        this.counterExample = counterExample;
    }

    public void mouseDoubleClick(MouseEvent event) {
        ViewerCell cell = this.treeViewer.getCell(new Point(event.x, event.y));
        if (cell != null && cell.getColumnIndex() > 0) {
            int index = cell.getColumnIndex() - 1;
            index += this.counterExample.getInitPath().size();
            Animator animator = Animator.getAnimator();
            History history = animator.getHistory();
            try {
                CounterExampleHistoryHandler.showCounterExampleInAnimator();
                history.gotoPos(index);
            }
            catch (ExecutionException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
            catch (ProBException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
        }
    }
}

