/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.ltl;

import de.prob.core.Animator;
import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.ui.ltl.CounterExampleFigure;
import de.prob.ui.ltl.CounterExamplePropositionFigure;
import de.prob.ui.ltl.handler.CounterExampleHistoryHandler;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public final class CounterExamplePredicateFigure
extends CounterExamplePropositionFigure {
    protected final Hashtable<Ellipse, Integer> ellipses1 = new Hashtable();
    protected final Hashtable<Integer, Ellipse> ellipses2 = new Hashtable();

    public CounterExamplePredicateFigure(CounterExampleProposition model) {
        super(model);
    }

    @Override
    protected void drawProposition(CounterExamplePropositionFigure parent) {
        if (parent == null) {
            this.bounds = new Rectangle(50, 50, 50 * (this.model.getValues().size() * 2 + 1), 100);
            CounterExampleFigure counterExampleFigure = (CounterExampleFigure)this.getParent();
            Insets insets = this.getInsets();
            List<RectangleFigure> states = counterExampleFigure.getStates();
            int i = 0;
            while (i < states.size()) {
                RectangleFigure state = states.get(i);
                if (!counterExampleFigure.getChildren().contains(state)) {
                    state.setBounds(new Rectangle(100 * (i + 1) + insets.left, 50, 50, 100 + 2 * insets.top));
                    counterExampleFigure.add((IFigure)state, 0);
                }
                ++i;
            }
            this.getParent().setConstraint((IFigure)this, (Object)new Rectangle(this.bounds));
            this.removeAll();
            this.drawPropositionFigure(this.bounds, this.ellipses1, this.ellipses2, this.model.getStateId(), 30);
        }
    }

    private void drawPropositionFigure(Rectangle bounds, Hashtable<Ellipse, Integer> ellipses1, Hashtable<Integer, Ellipse> ellipses2, int stateId, int argumentHeight) {
        ellipses1.clear();
        ellipses2.clear();
        LtlCheckingCommand.PathType pathType = this.model.getPathType();
        List values = this.model.getValues();
        int i = 0;
        while (i < values.size()) {
            block9: {
                Ellipse ellipse;
                block8: {
                    CounterExampleValueType value = (CounterExampleValueType)values.get(i);
                    ellipse = new Ellipse();
                    ellipse.setAntialias(1);
                    ellipse.setLineWidth(2);
                    ellipse.setOpaque(true);
                    ellipse.addMouseListener((MouseListener)this);
                    ellipse.addMouseMotionListener((MouseMotionListener)this);
                    ellipse.setBackgroundColor(this.getEllipseColor(value));
                    ellipses1.put(ellipse, i);
                    ellipses2.put(i, ellipse);
                    Label label = new Label(value.toString());
                    label.setOpaque(false);
                    ellipse.setLayoutManager((LayoutManager)new BorderLayout());
                    ellipse.add((IFigure)label, (Object)BorderLayout.CENTER);
                    this.add((IFigure)ellipse);
                    int x = (bounds.x + 50) * (i + 1);
                    int y = bounds.y + argumentHeight + (pathType == LtlCheckingCommand.PathType.INFINITE ? 5 : 0);
                    ellipse.setBounds(new Rectangle(x, y, 50, 50));
                    if (i <= 0) break block8;
                    ChopboxAnchor source = new ChopboxAnchor((IFigure)ellipse);
                    Ellipse targetEllipse = ellipses2.get(i - 1);
                    if (targetEllipse == null) break block9;
                    ChopboxAnchor target = new ChopboxAnchor((IFigure)targetEllipse);
                    PolylineConnection connection = new PolylineConnection();
                    connection.setAlpha(30);
                    connection.setAntialias(1);
                    connection.setLineStyle(1);
                    connection.setLineWidth(2);
                    connection.setToolTip((IFigure)new Label(this.getOperationName(i - 1)));
                    connection.setSourceAnchor((ConnectionAnchor)source);
                    connection.setTargetAnchor((ConnectionAnchor)target);
                    PolygonDecoration decoration = new PolygonDecoration();
                    decoration.setAlpha(30);
                    decoration.setAntialias(1);
                    PointList decorationPointList = new PointList();
                    decorationPointList.addPoint(0, 0);
                    decorationPointList.addPoint(-1, 1);
                    decorationPointList.addPoint(-1, 0);
                    decorationPointList.addPoint(-1, -1);
                    decoration.setTemplate(decorationPointList);
                    connection.setAlpha(250);
                    decoration.setAlpha(250);
                    connection.setSourceDecoration((RotatableDecoration)decoration);
                    this.add((IFigure)connection);
                }
                if (i == values.size() - 1) {
                    if (pathType.equals((Object)LtlCheckingCommand.PathType.INFINITE)) {
                        String operationName = this.getOperationName(ellipses1.get(ellipse));
                        Ellipse target = ellipses2.get(this.model.getLoopEntry());
                        int alpha = 30;
                        Color loopTransitionColor = ColorConstants.black;
                        alpha = 250;
                        PolylineConnection loop = this.createLoop(this.getInsets(), ellipse, target, alpha, operationName, loopTransitionColor);
                        this.add((IFigure)loop);
                    } else if (pathType.equals((Object)LtlCheckingCommand.PathType.REDUCED)) {
                        Polyline reduced = this.createReduced(this.getInsets(), ellipse, 250);
                        this.add((IFigure)reduced);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void mouseDoubleClicked(MouseEvent me) {
        super.mouseDoubleClicked(me);
        int stateId = this.ellipses1.get(me.getSource());
        Logger.assertProB((String)"stateId >= 0", (stateId >= 0 ? 1 : 0) != 0);
        CounterExample ce = ((CounterExampleFigure)this.getParent()).getModel();
        if (ce != null) {
            stateId += ce.getInitPath().size();
            Animator animator = Animator.getAnimator();
            History history = animator.getHistory();
            try {
                CounterExampleHistoryHandler.showCounterExampleInAnimator();
                history.gotoPos(stateId);
            }
            catch (ExecutionException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
            catch (ProBException e) {
                Logger.notifyUser((String)"Internal Error. Please submit a bugreport", (Throwable)e);
            }
        }
    }
}

