/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.invcheck;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InvariantCheckDialog
extends Dialog {
    private final Collection<String> events;
    private ListViewer listviewer;
    private Collection<String> selected;

    public InvariantCheckDialog(Shell parentShell, Collection<String> events) {
        super(parentShell);
        this.events = new ArrayList<String>(events);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.getShell().setText("Constraint Based Invariant Check");
        composite.setLayout((Layout)new GridLayout());
        Label label1 = new Label(composite, 0);
        label1.setText("ProB will search for events which can violate the invariant. You can limit the analysis to some events.");
        Label label2 = new Label(composite, 0);
        label2.setText("If no event is chosen, all events will be checked.");
        this.listviewer = new ListViewer(composite, 2562);
        GridData listLayout = new GridData();
        listLayout.grabExcessHorizontalSpace = true;
        this.listviewer.getList().setLayoutData((Object)listLayout);
        this.listviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listviewer.setInput(this.events);
        this.listviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)sel;
                    ArrayList<String> newSelection = new ArrayList<String>();
                    for (Object item : ssel) {
                        newSelection.add(item.toString());
                    }
                    InvariantCheckDialog.this.selected = newSelection;
                }
            }
        });
        composite.pack();
        return composite;
    }

    public Collection<String> getSelected() {
        return this.selected;
    }
}

