/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.historyview;

import de.prob.ui.historyview.HistoryView;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public class ToggleShowParametersHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    private static final String COMMAND_ID = "de.prob.ui.history.toggleShowParameters";
    private static final String STATE_ID = "de.prob.ui.history.showParametersState";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        State state = event.getCommand().getState(STATE_ID);
        if (state == null) {
            throw new ExecutionException("Command state de.prob.ui.history.showParametersState not found");
        }
        boolean newFilterValue = this.toggleState(state);
        this.setShowParameters(newFilterValue);
        return null;
    }

    private boolean toggleState(State state) {
        Boolean show = (Boolean)state.getValue();
        state.setValue((Object)(show == false ? 1 : 0));
        return show == false;
    }

    private void setShowParameters(boolean show) throws ExecutionException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryView view = (HistoryView)page.findView("de.prob.ui.HistoryView");
        if (view == null) {
            throw new ExecutionException("View de.prob.ui.StateView not found");
        }
        view.setShowParameters(show);
    }

    public void updateElement(UIElement element, Map parameters) {
        State state = ToggleShowParametersHandler.getCurrentState(element.getServiceLocator());
        Boolean filterSet = (Boolean)state.getValue();
        element.setChecked(filterSet.booleanValue());
    }

    private static State getCurrentState(IServiceLocator locator) {
        ICommandService service = (ICommandService)locator.getService(ICommandService.class);
        Command command = service.getCommand(COMMAND_ID);
        State state = command.getState(STATE_ID);
        return state;
    }
}

