/*
 * Decompiled with CFR 0.152.
 */
package de.prob.ui.findvalidstate;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.ProBCommandJob;
import de.prob.core.command.FindValidStateCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.logging.Logger;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.ProBParserBaseAdapter;
import de.prob.prolog.term.PrologTerm;
import de.prob.ui.findvalidstate.FindValidStateFinishedListener;
import de.prob.ui.validators.PredicateValidator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindValidStateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (Animator.getAnimator().isMachineLoaded()) {
            this.findValidState(shell);
        } else {
            Logger.notifyUser((String)"No ProB animation running. This is a bug. Please submit a report. Error in declaraion for class DeadlockCheckHandler");
        }
        return null;
    }

    private void findValidState(Shell shell) throws ExecutionException {
        Animator animator = Animator.getAnimator();
        LanguageDependendAnimationPart ldp = animator.getLanguageDependendPart();
        PredicateValidator validator = new PredicateValidator(ldp);
        InputDialog dialog = new InputDialog(shell, "Find Valid State Freedom Check", "ProB will try to find a state satisfying the invariant and the predicate:", "1=1", (IInputValidator)validator);
        int status = dialog.open();
        if (status == 0) {
            this.startFindState(animator, ldp, dialog.getValue(), shell);
        }
    }

    private void startFindState(Animator animator, LanguageDependendAnimationPart ldp, String value, Shell shell) throws ExecutionException {
        PrologTerm predicate = this.parsePredicate(ldp, value);
        FindValidStateCommand command = new FindValidStateCommand(predicate);
        ProBCommandJob job = new ProBCommandJob("Searching for State satisfying Predicate", animator, (IComposableCommand)command);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new FindValidStateFinishedListener(shell));
        job.schedule();
    }

    private PrologTerm parsePredicate(LanguageDependendAnimationPart ldp, String input) throws ExecutionException {
        PrologTerm predicate;
        if (input != null && input.trim().isEmpty()) {
            predicate = null;
        } else {
            try {
                ProBParserBaseAdapter parser = new ProBParserBaseAdapter((ProBParserBase)ldp);
                predicate = parser.parsePredicate(input, false);
            }
            catch (Exception e) {
                throw new ExecutionException("Exception while parsing the input", (Throwable)e);
            }
        }
        return predicate;
    }
}

